# TODO: use system sqlite

# about versioning:
# https://github.com/tdlib/td/issues/2215

# check tag in Source-url every release

%def_disable static
# Enable or disable clang compiler...
%ifarch %e2k
%def_without clang
%else
%def_with clang
%endif

Name: tdlib
Version: 1.8.21
Release: alt2

Summary: Cross-platform library for building Telegram clients

License: Boost
Group: Development/C++
Url: https://github.com/tdlib/td

ExcludeArch: %ix86

#Source-url: %url/archive/v%version.tar.gz#/%name-%version.tar.gz
# Source-url: https://github.com/tdlib/td/commit/3870c29b158b75ca5e48e0eebd6b5c3a7994a000
Source: %name-%version.tar

Patch: %name-system-crypto.patch

#BuildRequires(pre): rpm-macros-ninja-build
#BuildRequires: ninja-build

BuildRequires: gperftools-devel
BuildRequires: gperf
BuildRequires: libssl-devel
BuildRequires: gcc-c++
BuildRequires: zlib-devel
BuildRequires: cmake

BuildRequires(pre): rpm-build-intro >= 2.1.5

# Building with default settings require at least 16 GB of free RAM.
# Builds on ARM and other low-memory architectures are failing.
#ExclusiveArch: %ix86 x86_64 arch64
ExcludeArch: armh

# minimalize memory using
%ifarch %ix86 armh
%define optflags_debug -g0
%endif


%if_with clang
BuildRequires: clang
BuildRequires: llvm llvm-devel
# clang-12: error: unsupported argument 'auto' to option 'flto='
%define optflags_lto -flto=thin
%remove_optflags -frecord-gcc-switches
%endif

# use no more than system_memory/6300 build procs (see https://bugzilla.altlinux.org/show_bug.cgi?id=35112)
%_tune_parallel_build_by_procsize 6300

%description
TDLib (Telegram Database library) is a cross-platform library for
building Telegram clients. It can be easily used from almost any
programming language.

%package devel
Summary: Development files for %name
Group: Development/C++
Requires: %name = %EVR

%package devel-static
Summary: Static libraries for %name
Group: Development/C++
Requires: %name-devel = %EVR

%description devel
%summary.

%description devel-static
%summary.

%prep
%setup
%patch -p2

%if_with packaged_sqlite
rm -rfv sqlite/
%endif

%build
%if_with clang
export CC=clang
export CXX=clang++
%endif

%cmake -DCMAKE_INSTALL_LIBDIR=%_lib -DBUILD_SHARED_LIBS=1
%cmake_build

%install
%cmakeinstall_std

%if_disabled static
rm -fv %buildroot%_libdir/*.a
%endif

#check
# inet only
#./BUILD/test/run_all_tests --filter -client

%files
%doc LICENSE_1_0.txt
%doc README.md CHANGELOG.md
%_libdir/libtd*.so.%version

%files devel
%_includedir/td
%_libdir/libtd*.so
%_pkgconfigdir/*.pc
%_libdir/cmake/Td/
%exclude %_libdir/cmake/Td/TdStaticTarget*

%if_enabled static
%files devel-static
%_libdir/libtd*.a
%_libdir/cmake/Td/TdStaticTarget*
%endif

%changelog
