%global import_path github.com/influxdata/telegraf

%global _unpackaged_files_terminate_build 1

Name:		telegraf
Version:	1.33.0
Release:	alt1
Summary:	The plugin-driven server agent for collecting and reporting metrics

Group:		Development/Other
License:	MIT
URL:		https://github.com/influxdata/telegraf

Source0:	%name-%version.tar

Source101: telegraf.logrotate
Source102: telegraf.init
Source103: telegraf.service
Source104: telegraf.tmpfiles

ExclusiveArch:  %go_arches
BuildRequires(pre): rpm-macros-golang
BuildRequires: rpm-build-golang golang >= 1.23.0

%description
Telegraf is an agent written in Go for collecting, processing, aggregating, and writing metrics.

Design goals are to have a minimal memory footprint with a plugin system so that developers
in the community can easily add support for collecting metrics from well known services
(like Hadoop, Postgres, or Redis) and third party APIs (like Mailchimp, AWS CloudWatch,
or Google Analytics).

%prep
# $ git rm -rf vendor
# $ go mod vendor -v
# $ git add -f vendor
# $ git commit -m "update go pkgs by go mod vendor"

%setup -q

%build
export BUILDDIR="$PWD/.gopath"
export IMPORT_PATH="%import_path"
export GOPATH="$BUILDDIR:%go_path"
export GOFLAGS="-mod=vendor"

%golang_prepare

pushd $BUILDDIR/src/%import_path
export INTERNAL_PKG=github.com/influxdata/telegraf/internal
export VERSION=%version
export COMMIT=%release
export BRANCH=altlinux

CGO_ENABLED=0 go install -ldflags " \
    -X $INTERNAL_PKG.Version=$VERSION \
    -X $INTERNAL_PKG.Commit=$COMMIT \
    -X $INTERNAL_PKG.Branch=$BRANCH \
%ifarch %arm %ix86 %mips32
    -w -s \
%endif
    " -a ./cmd/telegraf
popd

$BUILDDIR/bin/telegraf config > etc/telegraf.conf

%install
export BUILDDIR="$PWD/.gopath"
export GOPATH="%go_path"
%golang_install

# cleanup
rm -rf -- %buildroot%_datadir

# Install config files
install -p -D -m 640 etc/telegraf.conf %buildroot%_sysconfdir/%name/%name.conf
install -d -m 750 %buildroot%_sysconfdir/%name/%name.d
# Setup directories
install -d -m 755 %buildroot%_logdir/%name
install -d -m 750 %buildroot%_sharedstatedir/%name
# Install pid directory
install -d -m 775 %buildroot%_runtimedir/%name
# Install logrotate
install -p -D -m 644 %SOURCE101 %buildroot%_logrotatedir/%name
# Install sysv init scripts
install -p -D -m 755 %SOURCE102 %buildroot%_initdir/%name
# Install systemd unit services
install -p -D -m 644 %SOURCE103 %buildroot%_unitdir/%name.service
install -p -D -m 644 %SOURCE104 %buildroot%_tmpfilesdir/%name.conf

%pre
%_sbindir/groupadd -r -f %name 2>/dev/null ||:
%_sbindir/useradd -r -g %name -G %name  -c 'Telegraf Agent Daemon' \
        -s /sbin/nologin  -d %_sharedstatedir/%name %name 2>/dev/null ||:
%_sbindir/usermod -a -G proc telegraf ||:

%post
%post_service %name

%preun
%preun_service %name

%files
%doc docs/*
%_bindir/%name
%_initdir/%name
%_unitdir/%name.service
%_tmpfilesdir/%name.conf
%dir %attr(0750, root, %name) %_sysconfdir/%name
%dir %attr(0750, root, %name) %_sysconfdir/%name/%name.d
%config(noreplace) %attr(0640, root, %name) %_sysconfdir/%name/%name.conf
%config(noreplace) %_logrotatedir/%name
%dir %attr(0770, root, %name) %_logdir/%name
%dir %attr(0775, root, %name) %_runtimedir/%name
%dir %attr(0750, %name, %name) %_sharedstatedir/%name

%changelog
