%def_disable snapshot
%define _libexecdir %_prefix/libexec

%def_disable static
%def_enable gtk_doc
%def_enable introspection
%def_enable vala
%def_enable check
# not ready for python3 yet
%def_disable installed_tests

Name: telepathy-glib
Version: 0.24.2
Release: alt4

Summary: Telepathy framework - GLib connection manager library
License: LGPL-2.1
Group: System/Libraries
Url: https://telepathy.freedesktop.org/wiki/TelepathyGLib

#Vcs: https://github.com/TelepathyIM/telepathy-glib.git
Vcs: https://gitlab.freedesktop.org/telepathy/telepathy-glib.git

%if_disabled snapshot
Source: https://telepathy.freedesktop.org/releases/telepathy-glib/%name-%version.tar.gz
%else
Source: %name-%version.tar
%endif

Patch10: telepathy-glib-0.24.2-up-test-cm.patch
Patch11: %name-0.24.1-up-gcc-14.patch

%define glib_ver 2.36.0
%define dbus_ver 0.90
%define gir_ver 0.10.3
%define vala_ver 0.16.0

BuildRequires(pre): rpm-build-python3
BuildRequires: glib2-devel >= %glib_ver
BuildRequires: libgio-devel >= %glib_ver
BuildRequires: libdbus-glib-devel >= %dbus_ver
BuildRequires: gtk-doc
%{?_enable_introspection:BuildRequires: gobject-introspection-devel >= %gir_ver}
%{?_enable_vala:BuildRequires: vala-tools >= %vala_ver}
%{?_enable_check:BuildRequires: /proc dbus-tools-gui}

%description
This package contains telepathy-glib, a GLib-based library for Telepathy
components.

%package -n lib%name
Summary: Telepathy framework - GLib connection manager library
Group: System/Libraries

Obsoletes: %name
Provides: %name = %EVR

%description -n lib%name
This package contains telepathy-glib, a GLib-based library for Telepathy
components.

%package -n lib%name-devel
Summary: Development libraries and header files for %name
Group: Development/C
Requires: lib%name = %EVR

Obsoletes: %name-devel
Provides: %name-devel = %EVR

%description -n lib%name-devel
Development libraries and header files for %name.

%package -n lib%name-devel-doc
Summary: Development documentation for %name
Group: Development/Documentation
BuildArch: noarch
Conflicts: lib%name < %version

%description -n lib%name-devel-doc
This package contains development documentation for the %name

%package -n lib%name-gir
Summary: GObject introspection data for the %name library
Group: System/Libraries
Requires: lib%name = %EVR

%description -n lib%name-gir
GObject introspection data for the %name library

%package -n lib%name-gir-devel
Summary: GObject introspection devel data for the %name
Group: System/Libraries
BuildArch: noarch
Requires: lib%name-gir = %EVR

%description -n lib%name-gir-devel
GObject introspection devel data for the %name library

%package -n lib%name-vala
Summary: Vala language bindings for the %name library
Group: Development/Other
BuildArch: noarch
Requires: lib%name = %EVR

%description -n lib%name-vala
This package provides Vala language bindings for the %name library

%package -n lib%name-tests
Summary: Tests for the %name package
Group: Development/Other
Requires: lib%name = %EVR

%description -n lib%name-tests
This package provides tests programs that can be used to verify
the functionality of the installed %name library package.

%prep
%setup
%patch10 -p1
%patch11 -p1 -b .gcc-14
sed -i 's;\(\/bin\/python\)$;\13;' tests/*.py
sed -i 's;\(env python\)$;\13;' examples/client/python/*.py

%build
%add_optflags %(getconf LFS_CFLAGS)
%autoreconf
%configure \
    %{subst_enable static} \
    %{?_enable_gtk_doc:--enable-gtk-doc} \
    %{subst_enable introspection} \
    %{?_enable_vala:--enable-vala-bindings} \
    %{?_enable_installed_tests:--enable-installed-tests} \
    PYTHON=%__python3
%make_build

%install
%makeinstall_std

%check
export TP_TESTS_NO_TIMEOUT=1
%make -k check CHECK_VERBOSE=1

%files -n lib%name
%doc AUTHORS ChangeLog
%_libdir/lib*.so.*

%files -n lib%name-devel
%_libdir/lib*.so
%_pkgconfigdir/*.pc
%dir %_includedir/telepathy-1.0/telepathy-glib
%_includedir/telepathy-1.0/telepathy-glib/*.h
%dir %_includedir/telepathy-1.0/telepathy-glib/_gen
%_includedir/telepathy-1.0/telepathy-glib/_gen/*.h

%files -n lib%name-devel-doc
%_datadir/gtk-doc/html/*

%if_enabled vala
%files -n lib%name-vala
%_datadir/vala/vapi/telepathy-glib.deps
%_datadir/vala/vapi/telepathy-glib.vapi
%endif

%if_enabled introspection
%files -n lib%name-gir
%_typelibdir/*

%files -n lib%name-gir-devel
%_girdir/*
%endif

%if_enabled installed_tests
%files -n lib%name-tests
%_bindir/telepathy-example*
%_libexecdir/telepathy-example*
%_libdir/%name-tests/
%_datadir/dbus-1/services/org.freedesktop.Telepathy.ConnectionManager.example*
%_datadir/telepathy/managers/example_*
%endif

%changelog
