%define _unpackaged_files_terminate_build 1

%ifarch %ix86
# This is necessary to avoid rustc-LLVM ERROR: out of memory.
%def_without debuginfo
%else
%def_with debuginfo
%endif

%define tbird_cid        \{3550f703-e582-4d05-9a08-453d09bdfdc6\}
%define tbird_prefix     %_libdir/thunderbird
%define tbird_datadir    %_datadir/thunderbird
%define tbird_idldir     %_datadir/idl/thunderbird
%define tbird_includedir %_includedir/thunderbird
%define tbird_develdir   %tbird_prefix-devel

Name: thunderbird
Version: 141.0
Release: alt1

Summary: Thunderbird is Mozilla's e-mail client
License: MPL-2.0
Group: Networking/Mail
URL: https://www.thunderbird.net
ExclusiveArch: %thunderbird_arches

Packager: Ajrat Makhmutov <rauty@altlinux.org>

Source0: %name-%version.tar
Source1: thunderbird.cpp
Source3: thunderbird.desktop
Source4: thunderbird-mozconfig
Source5: thunderbird-default-prefs.js
Source6: l10n.tar

### Start Patches
Patch001: 0001-thunderbird-115-add-loongarch-support.patch
Patch002: 0002-Fix-the-botan-build-for-loongarch64.patch
Patch003: 0003-Disable-browser-option.patch
Patch004: 0004-Fix-types-defination.patch
Patch005: 0005-Fix-wrong-redefinition-of-double_t-on-i586.patch
Patch006: 0006-Correction-of-the-Russian-translation.patch
Patch007: 0007-ALT-stop-putting-commonDialogs.properties-into-share.patch
### End Patches

Provides: mailclient
Requires: hunspell-en
# ALT #40907
Requires: libotr5

BuildRequires(pre): rpm-macros-thunderbird
BuildRequires(pre): mozilla-common-devel
BuildRequires(pre): browser-plugins-npapi-devel
# Python requires
BuildRequires: /dev/shm
# Rust requires
BuildRequires: /proc
BuildRequires: clang
BuildRequires: clang-devel
BuildRequires: llvm-devel
%ifarch loongarch64
BuildRequires: binutils
%else
BuildRequires: lld-devel
%endif
%ifarch armh %{ix86}
%filter_from_requires /libc.so.6(GLIBC_PRIVATE)/d
BuildRequires: gcc
BuildRequires: gcc-c++
%endif
BuildRequires: libstdc++-devel
BuildRequires: rust-cargo
BuildRequires: cbindgen
BuildRequires: libXt-devel libX11-devel libXext-devel libXft-devel libXScrnSaver-devel
BuildRequires: libXcursor-devel
BuildRequires: libXi-devel
BuildRequires: libXcomposite-devel
BuildRequires: libXdamage-devel
BuildRequires: libcurl-devel libgtk+2-devel libgtk+3-devel libhunspell-devel libjpeg-devel
BuildRequires: xorg-cf-files chrpath alternatives yasm
BuildRequires: zip unzip
BuildRequires: bzlib-devel zlib-devel
BuildRequires: libcairo-devel libpixman-devel
BuildRequires: libGL-devel
BuildRequires: libwireless-devel
BuildRequires: libalsa-devel
BuildRequires: libnotify-devel
BuildRequires: libevent-devel
BuildRequires: libproxy-devel
BuildRequires: libshell
BuildRequires: libvpx-devel
BuildRequires: libgio-devel
BuildRequires: libfreetype-devel fontconfig-devel
BuildRequires: libstartup-notification-devel
BuildRequires: libffi-devel
BuildRequires: gstreamer-devel gst-plugins-devel
BuildRequires: libopus-devel
BuildRequires: libpulseaudio-devel
BuildRequires: libdbus-devel libdbus-glib-devel
BuildRequires: node
BuildRequires: nasm
BuildRequires: libxkbcommon-devel
BuildRequires: libdrm-devel
BuildRequires: libaom-devel
BuildRequires: libdav1d-devel
%if_with debuginfo
BuildRequires: dump_syms
%endif

BuildRequires: pkgconfig(alsa)
BuildRequires: pkgconfig(aom)
BuildRequires: pkgconfig(bzip2)
BuildRequires: pkgconfig(cairo)
BuildRequires: pkgconfig(dav1d)
BuildRequires: pkgconfig(dbus-1)
BuildRequires: pkgconfig(dbus-glib-1)
BuildRequires: pkgconfig(dri)
BuildRequires: pkgconfig(fontconfig)
BuildRequires: pkgconfig(freetype2)
BuildRequires: pkgconfig(gio-2.0)
BuildRequires: pkgconfig(graphite2)
BuildRequires: pkgconfig(gtk+-2.0)
BuildRequires: pkgconfig(gtk+-3.0)
BuildRequires: pkgconfig(harfbuzz)
BuildRequires: pkgconfig(hunspell)
BuildRequires: pkgconfig(icu-i18n)
BuildRequires: pkgconfig(libcurl)
BuildRequires: pkgconfig(libdrm)
BuildRequires: pkgconfig(libevent)
BuildRequires: pkgconfig(libffi)
BuildRequires: pkgconfig(libjpeg)
BuildRequires: pkgconfig(libnotify)
BuildRequires: pkgconfig(libproxy-1.0)
BuildRequires: pkgconfig(libpulse)
BuildRequires: pkgconfig(libstartup-notification-1.0)
BuildRequires: pkgconfig(opus)
BuildRequires: pkgconfig(pixman-1)
BuildRequires: pkgconfig(vpx)
BuildRequires: pkgconfig(x11)
BuildRequires: pkgconfig(xcomposite)
BuildRequires: pkgconfig(xcursor)
BuildRequires: pkgconfig(xdamage)
BuildRequires: pkgconfig(xext)
BuildRequires: pkgconfig(xft)
BuildRequires: pkgconfig(xi)
BuildRequires: pkgconfig(xkbcommon)
BuildRequires: pkgconfig(xrandr)
BuildRequires: pkgconfig(xscrnsaver)
BuildRequires: pkgconfig(xt)
BuildRequires: pkgconfig(xtst)
BuildRequires: pkgconfig(zlib)
BuildRequires: python3-base
BuildRequires: python3(click)
BuildRequires: python3(curses)
BuildRequires: python3(hamcrest)
BuildRequires: python3(pip)
BuildRequires: python3(setuptools)
BuildRequires: python3(sqlite3)
# A copy of the imp module that was removed in python3.12
# It shouldn't be used, should use `importlib.metadata` instead
BuildRequires: python3(imp)
BuildRequires: libnspr-devel
BuildRequires: libnss-devel
BuildRequires: autoconf_2.13
%set_autoconf_version 2.13

%description
Thunderbird is Mozilla's next generation e-mail client. Thunderbird makes
emailing safer, faster and easier than ever before and can also scale to meet
the most sophisticated organizational needs.

The package contains Lightning - an integrated calendar for Thunderbird.

%prep
%setup -a6
%patch1 -p2
%patch2 -p2
%patch3 -p2
%patch4 -p2
%patch5 -p2
%patch6 -p1
%patch7 -p2

cp -fv %SOURCE4 .mozconfig
cat >> .mozconfig <<'EOF'
ac_add_options --prefix="%_prefix"
ac_add_options --libdir="%_libdir"
%ifnarch armh %{ix86} ppc64le loongarch64
ac_add_options --enable-linker=lld
%endif
%ifarch %{arm} %{ix86}
# See linker flags in the build section.
ac_add_options --enable-linker=bfd
%endif
%ifnarch x86_64
ac_add_options --disable-webrtc
%endif
%ifarch armh %{ix86} x86_64
ac_add_options --disable-elf-hack
%endif
%ifarch armh
ac_add_options --disable-av1
ac_add_options --disable-rust-simd
%endif
EOF

%if_with debuginfo
cat >> .mozconfig <<EOF
# Enabled debuginfo.
ac_add_options --disable-strip
ac_add_options --disable-install-strip
ac_add_options --enable-debug-symbols
%ifarch loongarch64 riscv64
# Even without crashreporter, useful debuginfo is produced
# on these platforms
ac_add_options --disable-crashreporter
%else
# Debug symbols are not built without crashreporter:
# "Skipping symbols generation because MOZ_CRASHREPORTER is not set".
ac_add_options --enable-crashreporter
%endif
EOF
%else
cat >> .mozconfig <<EOF
# Disabled  debuginfo.
ac_add_options --enable-strip
ac_add_options --enable-install-strip
ac_add_options --disable-debug-symbols
# Crashreporter without debuginfo is useless.
ac_add_options --disable-crashreporter
EOF
%endif

# Non blocking stdout for NodeJS
cat > "/tmp/node-stdout-nonblocking-wrapper" << ENDL.
#!/bin/sh
exec /usr/bin/node "\$@" 2>&1 | cat -
ENDL.
chmod +x /tmp/node-stdout-nonblocking-wrapper
echo 'export NODEJS="/tmp/node-stdout-nonblocking-wrapper"' >> .mozconfig

rm -rf -- third_party/python/setuptools/setuptools*
rm -rf -- third_party/python/setuptools/pkg_resources
rm -rf -- third_party/python/click/click*
rm -rf -- third_party/python/pip/pip*

%build
%add_optflags %optflags_shared
%add_findprov_lib_path %tbird_prefix

# Add fake RPATH
rpath="/$(printf %%s '%tbird_prefix' |tr '[:print:]' '_')"
export LDFLAGS="$LDFLAGS -Wl,-rpath,$rpath"

export MACH_BUILD_PYTHON_NATIVE_PACKAGE_SOURCE=system
export MOZ_APP_REMOTINGNAME="thunderbird"

./mach configure
./mach build

%if_with debuginfo
./mach buildsymbols
%endif

MOZ_LANGPACK_ID="$(grep MOZ_LANGPACK_EID comm/mail/locales/Makefile.in | cut -f2 -d @)"
pushd l10n
for LANG in *; do
	USED_LANGPACK_ID=$(grep langpack- ${LANG}/manifest.json | tr '"' ' ' | awk '{print $3}' | cut -f2-3 -d @)
	if [ "${USED_LANGPACK_ID}" != "${MOZ_LANGPACK_ID}" ]; then
		echo "MOZ_LANGPACK_ID mismatch! '${USED_LANGPACK_ID}' != '${MOZ_LANGPACK_ID}'" ;
		echo "thunderbird-l10n l10n source '${LANG}' uses a different MOZ_LANGPACK_ID than defined in comm/mail/locales/Makefile.in!";
		exit 1 ;
	fi
done
popd

# This is necessary to configure the environment variables.
# It is written in C so that the process in the ps has the right name.
clang++ \
	-Wall -Wextra \
	-DMOZ_PLUGIN_PATH=\"%browser_plugins_path\" \
	-DMOZ_PROGRAM=\"%tbird_prefix/thunderbird-bin\" \
	-DMOZ_DIST_BIN=\"%tbird_prefix\"\
	%SOURCE1 -o thunderbird

%install
export SHELL=/bin/sh
export MACH_BUILD_PYTHON_NATIVE_PACKAGE_SOURCE=system
mkdir -p \
	%buildroot/%_bindir \
	%buildroot/%mozilla_arch_extdir/%tbird_cid \
	%buildroot/%mozilla_noarch_extdir/%tbird_cid \
	%buildroot/%_datadir/applications \
	#

DESTDIR=%buildroot ./mach install

MOZ_LANGPACK_ID="$(grep MOZ_LANGPACK_EID comm/mail/locales/Makefile.in | cut -f2 -d @)"
pushd l10n
for LANG in * ; do
	locale=$(basename ${LANG})
	lowercase_locale=$(echo ${locale} | tr 'A-Z' 'a-z')
	echo "preparing and working on 'thunderbird-l10n-${lowercase_locale}  (langpack-${locale}@${MOZ_LANGPACK_ID}.xpi)"
	mkdir -p %buildroot/%mozilla_noarch_extdir/%tbird_cid/langpack-${locale}@${MOZ_LANGPACK_ID}
	cp -rf $LANG/* %buildroot/%mozilla_noarch_extdir/%tbird_cid/langpack-${locale}@${MOZ_LANGPACK_ID}/
done
popd

(set +x
	for f in %buildroot/%tbird_develdir/*; do
		[ -L "$f" ] || continue

		t="$(readlink "$f")"
		r="$(relative "${t#%buildroot}" "${f#%buildroot}")"

		ln -vnsf -- "$r" "$f"
	done
)

(set +x
	mkdir -pv %buildroot/%tbird_prefix/dictionaries
	rm -vrf -- %buildroot/%tbird_prefix/dictionaries/*
	for suf in aff dic; do
		t="$(relative %_datadir/myspell/en_US.$suf %tbird_prefix/dictionaries/)"
		ln -vs "$t" %buildroot/%tbird_prefix/dictionaries/en-US.$suf
	done
)

rm -rf -- \
	%buildroot/%_bindir/thunderbird \
	%buildroot/%tbird_prefix/js \
	%buildroot/%tbird_prefix/regxpcom \
	%buildroot/%tbird_prefix/xpcshell \
	%buildroot/%tbird_prefix/xpidl \
	%buildroot/%tbird_prefix/xpt_dump \
	%buildroot/%tbird_prefix/xpt_link \
	%buildroot/%tbird_prefix/nsinstall \
	%buildroot/%tbird_prefix/removed-files \
	%buildroot/%tbird_prefix/thunderbird \
	%buildroot/%tbird_prefix/run-mozilla.sh \
	%buildroot/%tbird_prefix/README.txt \
	#

install -m755 thunderbird %buildroot/%_bindir/thunderbird
install -Dpm644 %SOURCE3 %buildroot/%_desktopdir/thunderbird.desktop
# install altlinux-specific configuration
install -Dpm644 %SOURCE5 %buildroot/%tbird_prefix/defaults/pref/all-altlinux.js

# icons
for s in 16 22 24 32 48 64 128 256; do
	install -Dpm644 \
		comm/mail/branding/thunderbird/default$s.png \
		%buildroot/%_iconsdir/hicolor/${s}x${s}/apps/thunderbird.png
done
install -Dm644 comm/mail/branding/thunderbird/TB-symbolic.svg \
        %buildroot%_iconsdir/hicolor/symbolic/apps/thunderbird-symbolic.svg

# Add real RPATH
(set +x
	rpath="/$(printf %%s '%tbird_prefix' |tr '[:print:]' '_')"

	find \
		%buildroot%tbird_prefix \
		%buildroot%mozilla_arch_extdir/%tbird_cid \
	-type f |
	while read f; do
		t="$(readlink -ev "$f")"

		file "$t" | fgrep -qs ELF || continue

		if chrpath -l "$t" | egrep -qs "R(UN)?PATH=$rpath"; then
			chrpath -r "%tbird_prefix" "$t"
		fi
	done
)

%files
%doc AUTHORS
%_bindir/*
%tbird_prefix
%mozilla_arch_extdir/%tbird_cid
%mozilla_noarch_extdir/%tbird_cid
%defattr(0644,root,root,0755)
%_datadir/applications/thunderbird.desktop
%_iconsdir/hicolor/*/apps/thunderbird.png
%_iconsdir/hicolor/symbolic/apps/thunderbird-symbolic.svg

%changelog
