%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%set_verify_elf_method strict

Name: tig
Version: 2.5.10
Release: alt1

Summary: Text-mode interface for git
License: GPLv2+
Group: Development/Other

URL: https://jonas.github.io/tig/
VCS: https://github.com/jonas/tig.git
Source: %name-%version.tar

Requires: git-core

BuildRequires: asciidoc
BuildRequires: hardlink
BuildRequires: libncursesw-devel
BuildRequires: libpcre-devel
BuildRequires: libreadline-devel
BuildRequires: xmlto
%{?!_without_check:%{?!_disable_check:
BuildRequires: /dev/pts
BuildRequires: git-core
BuildRequires: git-diff-highlight
BuildRequires: /proc
BuildRequires: util-linux
}}

%description
Tig is an ncurses-based text-mode interface for git. It functions mainly
as a Git repository browser, but can also assist in staging changes
for commit at chunk level and act as a pager for output from various
Git commands.

%prep
%setup

%build
# pcre-config(1) does not report this path alone without `-I`.
export C_INCLUDE_PATH=/usr/include/pcre
# Note: Does not pass `-fanalyzer -Werror -Wno-unused-variable` (LTO off).
%add_optflags %(getconf LFS_CFLAGS)
%autoreconf
%configure
%make_build V=1 src/tig doc-man

%install
install -pD -m755 src/tig %buildroot%_bindir/tig
install -pD -m755 contrib/tig-pick %buildroot%_bindir/tig-pick
install -pD -m644 doc/tig.1 %buildroot%_man1dir/tig.1
install -pD -m644 doc/tigrc.5 %buildroot%_man5dir/tigrc.5
install -pD -m644 doc/tigmanual.7 %buildroot%_man7dir/tigmanual.7
install -pD -m644 contrib/*.tigrc -t %buildroot%_datadir/tig
install -pD -m644 contrib/tig-completion.bash %buildroot%_datadir/bash-completion/completions/tig
install -pD -m644 contrib/tig-completion.bash %buildroot%_datadir/zsh/site-functions/tig-completion.bash
install -pD -m644 contrib/tig-completion.zsh  %buildroot%_datadir/zsh/site-functions/_tig
hardlink -y memcmp -v %buildroot%_datadir

%check
src/tig -v
src/tig -v | grep -Fx '%name version %version'
export C_INCLUDE_PATH=/usr/include/pcre
script -e -c 'make test' /dev/null
# This will rebuild everything with ASan.
script -e -c 'make test-address-sanitizer' /dev/null

%files
%doc COPYING NEWS.adoc README.adoc doc/manual.adoc
%_bindir/tig
%_bindir/tig-pick
%_man1dir/tig.1*
%_man5dir/tigrc.5*
%_man7dir/tigmanual.7*
%_datadir/tig
%_datadir/bash-completion/completions/tig
%_datadir/zsh/site-functions/_tig
%_datadir/zsh/site-functions/tig-completion.bash

%changelog
