%def_enable fastest
%def_disable debug
%def_disable devel
%def_disable profile
%def_enable shared
%def_disable uyield
%def_enable zlib
%def_enable bzip
%def_disable lzo
%def_disable lzma
%def_enable pthread
%def_enable off64
%def_disable check
#----------------------------------------------------------------------
%define subst_enable_to() %{expand:%%{?_enable_%{1}:--enable-%{2}}} %{expand:%%{?_disable_%{1}:--disable-%{2}}}

%{!?x86_64:%global x86_64 x86_64}

%define Name Tokyo Cabinet
Name: tokyocabinet
%define lname lib%name
Summary: A modern implementation of a DBM
Version: 1.4.47
Release: alt3
License: %lgpl2plus
Group: Databases
Packager: Vladimir Lettiev <crux@altlinux.org>
URL: http://fallabs.com/%name
Source: %name-%version.tar
Patch: %name-%version-%release.patch

BuildRequires(pre): rpm-build-licenses
%{?_enable_zlib:BuildRequires: zlib-devel}
%{?_enable_bzip:BuildRequires: bzlib-devel}
%{?_enable_lzo:BuildRequires: liblzo2-devel}
%{?_enable_lzma:BuildRequires: lzmalib-devel}

%description
%Name is a library of routines for managing a database. It is
the successor of QDBM. %Name runs very fast. For example, the
time required to store 1 million records is 1.5 seconds for a hash
database and 2.2 seconds for a B+ tree database. Moreover, the database
size is very small and can be up to 8EB. Furthermore, the scalability
of %Name is great.


%package utils
Summary: Command line tools for managing %Name databases
Group: Databases
Requires: %lname = %version-%release

%description utils
%Name is a library of routines for managing a database. It is
the successor of QDBM. %Name runs very fast. For example, the
time required to store 1 million records is 1.5 seconds for a hash
database and 2.2 seconds for a B+ tree database. Moreover, the database
size is very small and can be up to 8EB. Furthermore, the scalability
of %Name is great.
This package contains command line tools for managing %Name
databases.


%if_enabled shared
%package -n %lname
Summary: %Name library
Group: System/Libraries

%description -n %lname
%Name is a library of routines for managing a database. It is
the successor of QDBM. %Name runs very fast. For example, the
time required to store 1 million records is 1.5 seconds for a hash
database and 2.2 seconds for a B+ tree database. Moreover, the database
size is very small and can be up to 8EB. Furthermore, the scalability
of %Name is great.
%endif


%package -n %lname-devel
Summary: Headers for developing programs that will use %lname
Group: Development/C
Requires: %lname%{?_disable_shared:-devel-static} = %version-%release

%description -n %lname-devel
%Name is a library of routines for managing a database. It is
the successor of QDBM. %Name runs very fast. For example, the
time required to store 1 million records is 1.5 seconds for a hash
database and 2.2 seconds for a B+ tree database. Moreover, the database
size is very small and can be up to 8EB. Furthermore, the scalability
of %Name is great.
This package contains the libraries and header files needed for
developing with %lname.


%package doc
Summary: Documentation for %Name
Group: Documentation
BuildArch: noarch

%description doc
%Name is a library of routines for managing a database. It is
the successor of QDBM. %Name runs very fast. For example, the
time required to store 1 million records is 1.5 seconds for a hash
database and 2.2 seconds for a B+ tree database. Moreover, the database
size is very small and can be up to 8EB. Furthermore, the scalability
of %Name is great.
This package contains documentation for developers.


%prep
%setup
%patch -p1


%build
%define _optlevel 3
%ifarch %ix86 %x86_64
%add_optflags -minline-all-stringops
%endif
%autoreconf
%configure \
    %{subst_enable fastest} \
    %{subst_enable debug} \
    %{subst_enable devel} \
    %{subst_enable profile} \
    %{subst_enable shared} \
    %{subst_enable uyield} \
    %{subst_enable zlib} \
    %{subst_enable bzip} \
    %{subst_enable_to lzo exlzo} \
    %{subst_enable_to lzma exlzma} \
    %{subst_enable pthread} \
    %{subst_enable off64}
%make_build


%install
%make_install DESTDIR=%buildroot install
rm -f %buildroot%_datadir/%name/{COPYING,README,doc/*.ppt}
bzip2 --best %buildroot%_datadir/%name/ChangeLog
install -d -m 0755 %buildroot%_docdir
mv %buildroot{%_datadir/%name,%_docdir/%name-%version}

rm -fv %buildroot%_libdir/*.a

%check
%make_build check


%files utils
%_bindir/*
%_libexecdir/*.cgi
%_man1dir/*


%if_enabled shared
%files -n %lname
%_libdir/*.so.*
%endif


%files -n %lname-devel
%_includedir/*
%{?_enable_shared:%_libdir/*.so}
%_pkgconfigdir/*
%_man3dir/*


%files doc
%_docdir/%name-%version


%changelog
