%define _unpackaged_files_terminate_build 1

%define jss_version 5.2.0
%define tomcat_version 9.0.37
%define java_version 17

# tomcatjss was renamed dogtag-tomcatjss
%define tomcatjss_rebranded_version 8.2.0-alt1

Name: tomcatjss
Version: 8.4.1
Release: alt1

Summary: JSSE module for Apache Tomcat that uses JSS
License: LGPLv2+
Group: System/Libraries
Url: https://github.com/dogtagpki/tomcatjss
Vcs: https://github.com/dogtagpki/tomcatjss
Source: %name-%version.tar
Patch0: %name-%version-alt.patch

# - upstream doesn't support i586 (Fedora's Java 17 is not built for that arch)
# - ALT's Java 17 is not built for armh
ExcludeArch: %ix86 armh

BuildRequires(pre): rpm-macros-java
BuildRequires: /proc
BuildRequires: java-devel >= %java_version
BuildRequires: jpackage-generic-compat
BuildRequires: apache-commons-logging
BuildRequires: ant
BuildRequires: dogtag-jss >= %jss_version
BuildRequires: tomcat >= %tomcat_version

%description
JSS Connector for Apache Tomcat, installed via the tomcatjss package,
is a Java Secure Socket Extension (JSSE) module for Apache Tomcat that
uses Java Security Services (JSS), a Java interface to Network Security
Services (NSS).

%package -n dogtag-tomcatjss
Summary: JSS Connector for Apache Tomcat
Group: System/Libraries

Provides: tomcatjss = %EVR
Obsoletes: tomcatjss < %tomcatjss_rebranded_version

Requires: dogtag-jss >= %jss_version
Requires: tomcat >= %tomcat_version
Requires: apache-commons-logging
Requires: java >= %java_version

%description -n dogtag-tomcatjss
JSS Connector for Apache Tomcat, installed via the tomcatjss package,
is a Java Secure Socket Extension (JSSE) module for Apache Tomcat that
uses Java Security Services (JSS), a Java interface to Network Security
Services (NSS).

%prep
%setup
%autopatch -p1

%build
# get Tomcat <major>.<minor> version number
tomcat_version=`/usr/sbin/tomcat version | sed -n 's/Server number: *\([0-9]\+\.[0-9]\+\).*/\1/p'`
app_server=tomcat-$tomcat_version

ant -v -f build.xml \
    -Dversion=%version \
    -Dsrc.dir=$app_server \
    -Djnidir=%_jnidir \
    compile package

%install
ant -v -f build.xml \
    -Dversion=%version \
    -Dpackage=dogtag-tomcatjss \
    -Dinstall.doc.dir=%buildroot%_docdir \
    -Dinstall.jar.dir=%buildroot%_javadir \
    install

%files -n dogtag-tomcatjss
%doc %_docdir/dogtag-tomcatjss/
%_javadir/tomcatjss.jar

%changelog
