%define _unpackaged_files_terminate_build 1

%define abiversion 2

Name: toxcore
Version: 0.2.20
Release: alt1

Summary: Peer to peer (serverless) instant messenger
License: GPL-3.0-or-later
Group: System/Libraries
Url: https://github.com/TokTok/c-toxcore
VCS: https://github.com/TokTok/c-toxcore.git

Source: %name-%version.tar
Source1: %name-%version-cmp.tar

BuildRequires: libcheck-devel
BuildRequires: libconfig-devel
BuildRequires: libopus-devel
BuildRequires: libsodium-devel
BuildRequires: libvpx-devel

%description
Tox is a peer to peer (serverless) instant messenger aimed at making security
and privacy easy to obtain for regular users. It uses libsodium (based on NaCl)
for its encryption and authentication.

%package -n libtoxav%abiversion
Summary: Library for Tox protocol that provides audio/video functionality
Group: System/Libraries

%description -n libtoxav%abiversion
The `libtoxav1` library provides the necessary functionality for handling audio
vand video calls in the Tox protocol. It relies on external libraries like
`libopus` for audio encoding/decoding and `libvpx` for video processing. This
library is essential for Tox clients that support multimedia communication.

%package -n libtoxcore%abiversion
Summary: Library for Tox protocol that provides the messenger functionality
Group: System/Libraries

%description -n libtoxcore%abiversion
The `libtoxcore1` library is the core implementation of the Tox protocol. It
provides functionalities such as messaging, file transfer, and connection
management. This library is the foundation for all Tox clients and services.

%package -n libtoxencryptsave%abiversion
Summary: Library for Tox protocol that provides encryption of Tox profiles
Group: System/Libraries

%description -n libtoxencryptsave%abiversion
The `libtoxencryptsave1` library provides functionality for encrypting and
saving Tox profile data, such as private keys and settings. It ensures that
sensitive information is securely stored on disk.

%package bootstrapd
Summary: Highly configurable DHT bootstrap node daemon based on Tox protocol
Group: System/Libraries

%description bootstrapd
The `toxcore-bootstrapd` package provides a daemon for running a Tox bootstrap
node. Bootstrap nodes help new clients connect to the Tox network by providing
initial peer information. This package is essential for maintaining the
distributed nature of the Tox network.

%package devel
Summary: Development files for %name
Group: System/Libraries

%description devel
The `toxcore-devel` package provides header files and static libraries
necessary for developing applications that use the Toxcore libraries. It is
required for compiling and linking against `libtoxcore`, `libtoxav`, and
`libtoxencryptsave`.

%prep
%setup -a1

%build
%autoreconf
%configure \
  --enable-daemon \
  --enable-static=no \
  #

%make_build

%install
%makeinstall
rm -f %buildroot%_bindir/DHT_bootstrap
install -d -m700 %buildroot/var/lib/tox-bootstrapd/
install -D -m644 other/bootstrap_daemon/tox-bootstrapd.conf \
  %buildroot/etc/tox-bootstrapd.conf
install -D -m644 other/bootstrap_daemon/tox-bootstrapd.service \
  %buildroot%_unitdir/tox-bootstrapd.service
sed -i "s|/usr/local/bin|%_bindir|g" %buildroot%_unitdir/tox-bootstrapd.service

%pre bootstrapd
/usr/sbin/groupadd -r -f tox-bootstrapd
/usr/sbin/useradd -r \
  -d /var/lib/tox-bootstrapd -s /dev/null \
  -c 'TOX DHT bootstrap daemon' \
  -g tox-bootstrapd tox-bootstrapd >/dev/null 2>&1 ||:

%files -n libtoxav%abiversion
%_libdir/libtoxav.so.%{abiversion}*

%files -n libtoxcore%abiversion
%_libdir/libtoxcore.so.%{abiversion}*

%files -n libtoxencryptsave%abiversion
%_libdir/libtoxencryptsave.so.%{abiversion}*

%files bootstrapd
%doc other/bootstrap_daemon/README.md
%dir %attr(700,tox-bootstrapd,tox-bootstrapd) /var/lib/tox-bootstrapd
%_bindir/tox-bootstrapd
%_datadir/bash-completion/completions/tox-bootstrapd
%_sysconfdir/tox-bootstrapd.conf
%_unitdir/tox-bootstrapd.service

%files devel
%_includedir/tox
%_libdir/libtoxav.so
%_libdir/libtoxcore.so
%_libdir/libtoxencryptsave.so
%_pkgconfigdir/libtoxav.pc
%_pkgconfigdir/libtoxcore.pc

%changelog
