%def_enable ffmpeg
%def_disable gstreamer
%def_enable gepub

Name: tumbler
Version: 4.20.0
Release: alt1

Summary: A thumbnail D-Bus service
License: GPLv2+ and LGPLv2+
Group: Graphical desktop/XFce

Url: https://docs.xfce.org/xfce/tumbler/start
Packager: Xfce Team <xfce@packages.altlinux.org>

Requires: lib%name = %version-%release

Vcs: https://gitlab.xfce.org/xfce/tumbler.git
Source: %name-%version.tar
Patch: %name-%version-%release.patch

BuildPreReq: rpm-build-xfce4 xfce4-dev-tools
BuildRequires: libxfce4util-devel >= 4.17.1
BuildRequires: libfreetype-devel libgio-devel libgtk+2-devel libjpeg-devel libpng-devel
BuildRequires: libpoppler-glib-devel libgsf-devel libcurl-devel
%{?!_with_bootstrap:BuildRequires: libopenraw-gnome-devel}
%{?_enable_ffmpeg:BuildRequires: libffmpegthumbnailer-devel}
%{?_enable_gstreamer:BuildRequires: libgdk-pixbuf-devel gstreamer1.0-devel gst-plugins1.0-devel}
%{?_enable_gepub:BuildRequires: libgepub-devel libgdk-pixbuf-devel}
# NOTE: gtk-doc is required by build system even if docs are disabled.
BuildRequires: gtk-doc

%define _unpackaged_files_terminate_build 1

%description
Tumbler is a D-Bus service for applications to request
thumbnails for various URI schemes and MIME types.
It is an implementation of the thumbnail management D-Bus
specification

%package -n lib%name
Summary: A D-bus thumbnailing framweork
Group: System/Libraries
License: LGPLv2+

%description -n lib%name
Tumbler is a D-Bus service for applications to request
thumbnails for various URI schemes and MIME types

%package -n lib%name-devel
Summary: Development files for %name
Group: Development/C
License: LGPLv2+
Requires: lib%name = %version-%release

%description -n lib%name-devel
Development files and headers for %name

%prep
%setup
%patch -p1

%build
%xfce4reconf
%configure \
	--libexecdir=%_prefix/libexec \
	%{?_disable_ffmpeg:--disable-ffmpeg-thumbnailer} \
	%{?_disable_gstreamer:--disable-gstreamer-thumbnailer} \
	%{?_disable_gepub:--disable-gepub-thumbnailer} \
	--disable-static \
	--disable-gtk-doc

%make_build

%install
%makeinstall_std
%find_lang %name

%files -f %name.lang
%doc AUTHORS NEWS
%_sysconfdir/xdg/%name
%_prefix/libexec/%name-1
%_libdir/%name-1
%_datadir/dbus-1/services/*.service
%_user_unitdir/*.service
%_iconsdir/hicolor/*/apps/*

%exclude %_libdir/%name-1/plugins/*.la
%exclude %_libdir/%name-1/plugins/cache/*.la

%files -n lib%name
%_libdir/*.so.*

%files -n lib%name-devel
%_includedir/%name-1
%_libdir/*.so
%_pkgconfigdir/*.pc

%changelog
