Name: u-boot-rpi3
Version: 2025.07
Release: alt1

Summary: Das U-Boot
License: GPLv2+
Group: System/Kernel and hardware
Url: https://docs.u-boot.org/en/latest/

ExclusiveArch: aarch64

Source: %name-%version-%release.tar

BuildRequires: bc dtc >= 1.4 flex libgnutls-devel libssl-devel libuuid-devel

%description
boot loader for embedded boards based on PowerPC, ARM, MIPS and several
other processors, which can be installed in a boot ROM and used to
initialize and test the hardware or to download and run application code.
This package supports Raspberry Pi 3/4 boards.

%define rpis rpi_3 rpi_3_b_plus rpi_4 rpi_arm64
%define img kernel8.img

%prep
%setup

%build
for board in %rpis; do
	O=build/${board}
	%make_build DTC=%_bindir/dtc O=${O} ${board}_defconfig all
	install -pm0644 -D ${O}/u-boot.bin out/${board}/%img
done

%install
mkdir -p %buildroot%_datadir/u-boot
cd out
find . -type f | cpio -pmd %buildroot%_datadir/u-boot

%files
%doc README doc/board/broadcom
%_datadir/u-boot/*

%changelog
