Name: u-boot-sunxi
Version: 2025.07
Release: alt1

Summary: Das U-Boot
License: GPLv2+
Group: System/Kernel and hardware
Url: https://docs.u-boot.org/en/latest/

%ifndef crossbuild
ExclusiveArch: aarch64
%endif

Source: %name-%version-%release.tar

Provides: u-boot-sunxi64 = %version-%release
Obsoletes: u-boot-sunxi64

BuildRequires: aarch64-none-elf-gcc
BuildRequires: atf-sunxi >= 2.12 bc ccache dtc >= 1.4 flex libgnutls-devel libssl-devel libuuid-devel
BuildRequires: python3(setuptools)
BuildRequires: python3(libfdt)

%description
boot loader for embedded boards based on PowerPC, ARM, MIPS and several
other processors, which can be installed in a boot ROM and used to
initialize and test the hardware or to download and run application code.
This package supports boards based on Allwinner SoCs.

See http://linux-sunxi.org/Bootable_SD_card#Bootloader for details.

%prep
%setup

%build
export SCP=/dev/null
export DTC=%_bindir/dtc
export CROSS_COMPILE=aarch64-none-elf-

boards=$(grep -lr MACH_SUN50I configs |sed 's,^configs/\(.\+\)_defconfig,\1,')
for board in $boards; do
	O=build/${board}
	export BL31=%_datadir/atf/sun50i_a64/bl31.bin
	grep -qF SUN50I_H6= configs/${board}_defconfig && \
		export BL31=%_datadir/atf/sun50i_h6/bl31.bin
	grep -qF SUN50I_H616= configs/${board}_defconfig && \
		export BL31=%_datadir/atf/sun50i_h616/bl31.bin
	%make_build HOSTCC='ccache gcc' O=${O} ${board}_defconfig all
	install -pm0644 -D ${O}/u-boot-sunxi-with-spl.bin out/${board}/u-boot-sunxi-with-spl.bin
done

%install
mkdir -p %buildroot%_datadir/u-boot
cd out
find . -type f | cpio -pmd %buildroot%_datadir/u-boot

%files
%doc README doc/board/allwinner
%_datadir/u-boot/*

%changelog
