Name: u-boot-tools
Version: 2025.07
Release: alt1

Summary: Das U-Boot
License: GPLv2+
Group: System/Kernel and hardware

Provides: uboot-tools = %version-%release
Obsoletes: uboot-tools

Source: %name-%version-%release.tar

BuildRequires: dtc flex libgnutls-devel libssl-devel libtinfo-devel libuuid-devel
BuildRequires: python3(libfdt)

%description
boot loader for embedded boards based on PowerPC, ARM, MIPS and several
other processors, which can be installed in a boot ROM and used to
initialize and test the hardware or to download and run application code.
This package contains U-Boot tools.

%prep
%setup

%build
%make_build DTC=%_bindir/dtc STRIP=: tools-only_defconfig tools-all

%install
HOSTPROGS="\
asn1_compiler
dumpimage
env/fw_printenv
fdt_add_pubkey
fdtgrep
fit_check_sign
fit_info
gen_eth_addr
ifwitool
img2srec
kwboot
mkeficapsule
mkenvimage
mkimage
mksunxiboot
preload_check_sign
printinitialenv
proftool
sunxi-spl-image-builder"

mkdir -p %buildroot%_bindir
for f in $HOSTPROGS; do
install -pm0755 tools/$f %buildroot%_bindir
done

install -pm0644 -D tools/env/fw_env.config %buildroot%_sysconfdir/fw_env.config
ln -s fw_printenv %buildroot%_bindir/fw_setenv

%files
%config(noreplace) %_sysconfdir/fw_env.config
%_bindir/*

%changelog
