Name: ucblogo
Version: 6.2.3
Release: alt1
Summary: An interpreter for the Logo programming language
Group: Development/Functional
License: GPLv2+
Source: %name-%version.tar.gz
Source1: logo-mode.tar.gz
Patch: FromUTF8.patch
Patch1: ucblogo-6.2.2-fix-desktop-file.patch
Url: http://www.cs.berkeley.edu/~bh

# Automatically added by buildreq on Tue Nov 23 2021
# optimized out: at-spi2-atk emacs-base emacs-common fontconfig glibc-kernheaders-generic glibc-kernheaders-x86 libat-spi2-core libcairo-gobject libgdk-pixbuf libgpg-error libp11-kit libstdc++-devel libwayland-client libwayland-cursor libwayland-egl libwxBase3.1-devel openssh-clients perl perl-Encode perl-Text-Unidecode perl-Unicode-EastAsianWidth perl-Unicode-Normalize perl-libintl perl-parent python3 python3-base sh4 tex-common texlive texlive-collection-basic texlive-dist
BuildRequires: emacs-nox gcc-c++ libX11-devel libwxGTK3.2-devel makeinfo texi2dvi libncursesw-devel

BuildRequires: autoconf-archive texi2html tex(manfnt.sty)

%description
Berkeley Logo (ucblogo) is an interpreter for the Logo programming
language. Logo is a computer programming language designed for use by
learners, including children. This dialect of Logo features
random-access arrays, variable number of inputs to user-defined
procedures, various error handling improvements, comments and
continuation lines, first-class instruction and expression templates,
and macros.

%package emacs
Summary: Emacs Logo mode
Group: Development/Functional
BuildArch: noarch
Requires: %name = %version-%release

%description emacs
Emacs mode for UCBLogo.

%prep
%setup
%setup -a 1
%patch -p1
%patch1 -p2

# no dot files in directories
sed -i  's|\.logo|dot.logo|g' emacs/dot.*
sed -i 's|/\.logo|/dot.logo|g' emacs/makefile
sed -i 's|\.LOOPS|dot.LOOPS|g' emacs/dot.*
sed -i 's|/\.LOOPS|/dot.LOOPS|g' emacs/makefile

# correct directories /usr/lib -> /usr/share and /usr/local ->  /usr
sed -i 's|/local/lib/logo|/share/logo|g' *.c README.md
sed -i 's|/lib/logo|/share/logo|g' *.c makefile*
sed -i "s|/usr/local/bin/logo|%_bindir/logo|g" docs/ucblogo.texi
sed -i "s|/usr/local/bin/logo|%_bindir/logo|g" README.md
sed -i "s|/usr/local/info|%_datadir/info|g" README.md

%build
%autoreconf
# build WX version
rm -f config.cache
%configure --x-includes=%_includedir --x-libraries=%_libdir --enable-x11 --with-wx-config=/usr/bin/wx-config
%make_build ucblogo
mv ucblogo logo-wx
# build traditional version
make clean
%configure --x-includes=%_includedir --x-libraries=%_libdir --enable-x11 --with-wx-config=no
%make_build
# compile emacs files
%make -C emacs BINDIR=%_bindir EMACSDIR=%_datadir/emacs/site-lisp/logo INFODIR=%_infodir LIBLOC=%_datadir/logo

make html

%install
%makeinstall

install -m0755 logo-wx %buildroot%_bindir
install -D %name.desktop %buildroot%_desktopdir/%name.desktop
install -D ucblogo.png %buildroot%_iconsdir/hicolor/256x256/apps/ucblogo.png

# install emacs files
%make -C emacs install BINDIR=%buildroot%_bindir EMACSDIR=%buildroot%_datadir/emacs/site-lisp/logo
mkdir -p %buildroot%_datadir/emacs/site-lisp/site-start.d
cp -f emacs/dot.emacs %buildroot%_datadir/emacs/site-lisp/site-start.d/logo-mode.el
rm %buildroot%_bindir/install-logo-mode
rm %buildroot%_datadir/emacs/site-lisp/logo/README
rm %buildroot%_datadir/emacs/site-lisp/logo/*.el

%files
%doc docs/*html docs/*.pdf README* plm changes.txt
%_bindir/*
%_datadir/ucblogo
%_infodir/*
%_man1dir/*
%_desktopdir/*
%_iconsdir/*/*/*/*
%_pixmapsdir/*
%exclude %_defaultdocdir/%name

%files emacs
%doc emacs/README
%_datadir/emacs/site-lisp/logo
%_datadir/emacs/site-lisp/site-start.d

%changelog
