%def_enable snapshot
%def_without gimp
%{?_with_gimp:%define gimpplugindir %(gimptool-2.0 --gimpplugindir)}

Name: ufraw
Version: 0.23
Release: alt0.6

Summary: UFRaw is a graphical utility for opening and converting RAW files from digital photo cameras
License: GPLv2+
Group: Graphics
Url: http://ufraw.sourceforge.net/

Vcs: https://github.com/sergiomb2/ufraw.git

%if_disabled snapshot
Source: http://downloads.sourceforge.net/%name/%name-%version.tar.gz
%else
# none-official repo

Source: %name-%version.tar
%endif
# https://github.com/sergiomb2/ufraw/issues/12
Patch1: ufraw-0.22-r4-up-exiv2-0.28.patch

Requires(pre): GConf

%ifnarch %e2k
# lcc-1.23.12: ftbfs on ufraw_developer.c:862
BuildRequires: libgomp-devel
%endif
BuildRequires: gcc-c++
BuildRequires: gettext
# >= 0.21
BuildRequires: liblensfun-devel >= 0.2.5
BuildRequires: libexiv2-devel >= 0.20
BuildRequires: liblcms2-devel libgtkimageview-devel
BuildRequires: libjpeg-devel liblensfun-devel libpng-devel libtiff-devel
BuildRequires: libcfitsio-devel zlib-devel bzlib-devel perl-podlators
BuildRequires: libjasper-devel
BuildRequires: libGConf-devel
%{?_with_gimp_plugin: libgimp-devel}

%package -n gimp-plugin-ufraw
Summary: GIMP plugin for opening and converting RAW files from digital photo cameras (part of UFRaw project)
Group: Graphics
Conflicts: rawphoto
Requires: gimp
Obsoletes: gimp2-plugin-ufraw

%description
UFRaw is a graphical utility for opening and converting RAW files from digital
photo cameras.

%description -n gimp-plugin-ufraw
GIMP plugin for opening and converting RAW files from digital photo cameras
(part of UFRaw project).

%prep
%setup
%patch1 -p1

# downgrade gettext required version
sed -i 's;\[0.21\];[0.20.2];' configure.ac

%build
%define _optlevel 3
%add_optflags %(getconf LFS_CFLAGS)
%autoreconf
%configure \
	--enable-contrast \
%ifnarch %e2k
	--enable-openmp \
%endif
	--enable-mime \
	--enable-extras \
    %{subst_with gimp}
%nil
%make_build schemasdir=%_sysconfdir/gconf/schemas

%install
%makeinstall_std schemasdir=%_sysconfdir/gconf/schemas
install -d %buildroot%_datadir/ufraw
install -pD -m644 icons/ufraw.png %buildroot%_liconsdir/ufraw.png

%find_lang ufraw

%post
%gconf2_install %name

%preun
if [ $1 = 0 ]; then
%gconf2_uninstall %name
fi

%files -f ufraw.lang
%_bindir/*
%exclude  %_bindir/dcraw
%_datadir/%name/
%_man1dir/*
%_desktopdir/*
%_liconsdir/*
%_pixmapsdir/*
%_sysconfdir/gconf/schemas/%name.schemas
%_datadir/appdata/%name.appdata.xml
%doc MANIFEST README

%{?_with_gimp_plugin:
%files -n gimp-plugin-ufraw
%gimpplugindir/plug-ins/*}

%changelog
