# Unpackaged files in buildroot should terminate build
%define _unpackaged_files_terminate_build 1

Name: vcmi
Version: 1.6.4
Release: alt1

Summary: Open-source project aiming to reimplement HMM3:WoG game engine
License: GPL-2.0-or-later
Group: Games/Strategy

Url: http://wiki.vcmi.eu/index.php?title=Main_Page
Source0: %name-%version.tar
Patch: %name-%version-%release.patch

# Currently only luajit compiles with VCMI
ExclusiveArch: %luajit_arches

# for %%luajit_arches macro
BuildRequires(pre): rpm-macros-luajit
BuildRequires(pre): rpm-macros-cmake
BuildRequires: cmake gcc-c++
BuildRequires: doxygen
BuildRequires: boost-devel
BuildRequires: boost-filesystem-devel
BuildRequires: boost-locale-devel
BuildRequires: boost-program_options-devel
BuildRequires: boost-asio-devel
BuildRequires: boost-interprocess-devel
BuildRequires: boost-geometry-devel
BuildRequires: pkgconfig(libavcodec)
BuildRequires: pkgconfig(libavdevice)
BuildRequires: pkgconfig(libavformat)
BuildRequires: pkgconfig(libavutil)
BuildRequires: pkgconfig(libpostproc)
BuildRequires: pkgconfig(libswscale)
BuildRequires: pkgconfig(libswresample)
BuildRequires: pkgconfig(libavfilter)
BuildRequires: pkgconfig(minizip)
BuildRequires: pkgconfig(Qt6Network)
BuildRequires: pkgconfig(Qt6Widgets)
BuildRequires: pkgconfig(sdl2)
BuildRequires: pkgconfig(SDL2_image)
BuildRequires: pkgconfig(SDL2_mixer)
BuildRequires: pkgconfig(SDL2_ttf)
BuildRequires: pkgconfig(zlib)
BuildRequires: tbb-devel
BuildRequires: libfuzzylite-devel >= 6.0
BuildRequires: libluajit-devel
BuildRequires: qt6-tools-devel
#BuildRequires: git-core

Requires: ffmpeg

Summary(ru_RU.UTF-8): Open-source движок для игры HMM3:WoG

%description
The purpose of VCMI project is to rewrite entire HOMM 3: WoG engine from
scratch, giving it new and extended possibilities. We hope to support
mods and new towns already made by fans but abandoned because of game
code limitations.

VCMI is fan-made open-source project in progress. We already allow
support for maps of any sizes, higher resolutions and extended engine
limits. However, although working, the game is not finished. There are
still many features and functionalities to add, both old and brand new.

As yet VCMI is not standalone program, it uses Wake of Gods files and
graphics. You need to install WoG before running VCMI.

%description -l ru_RU.UTF8
Цель проекта VCMI состоит в том, чтобы переписать полностью движок
HoMM 3: WoG и тем самым дать ему новые и расширенные возможности.
Мы надеемся реализовать поддержку модов и новых городов, которые уже
сделаны фанатами, но от которых отказались из-за ограничений кода игры.

VCMI - это фанатский проект с открытым исходным кодом. Мы уже реализовали
поддержку карт любых размеров, более высокое разрешение и расширенные
возможности движка. Тем не менее, хотя игра и работает, она ещё не
закончена. Есть еще много особенностей, которые нужно добавить, как
старых, так и новых.

Пока VCMI не отдельная программа, она использует файлы от Wake of Gods.
Вам нужно установить WoG перед запуском VCMI.

%prep
%setup
%patch -p1

%ifarch %e2k
# unsupported as of lcc 1.24.11
%add_optflags -fno-error-always-inline
%endif

%build
%cmake \
       -DCMAKE_INSTALL_LIBDIR=%_lib \
       -DCMAKE_SKIP_RPATH=OFF \
       -DENABLE_TEST=OFF \
       -DFORCE_BUNDLED_FL=OFF \
       -DENABLE_INNOEXTRACT=OFF

%cmake_build

%install
%cmake_install
mv %buildroot/%_libdir/%name/libvcmi.so %buildroot/%_libdir/libvcmi.so
mv %buildroot/%_libdir/%name/libvcmiqt.so %buildroot/%_libdir/libvcmiqt.so
rm -f %buildroot%_libdir/*.a

%files
%doc docs/*
%_bindir/%{name}*
%_datadir/%name/
%_datadir/metainfo/eu.vcmi.VCMI.metainfo.xml
%_desktopdir/*.desktop
%_iconsdir/hicolor/*/apps/*.png
%_iconsdir/hicolor/scalable/apps/*.svg
%_libdir/libvcmi.so
%_libdir/libvcmiqt.so
%_libdir/%name/

%changelog
