%def_enable introspection
%def_enable gtk_doc
%def_disable static
%def_disable orc

Name: vips
Version: 8.16.0
Release: alt1

Summary: Large image processing library

License: LGPLv2.1
Group: Graphics
Url: https://libvips.github.io/libvips/

# Source0-url: https://github.com/libvips/libvips/archive/v%version.tar.gz
Source0: %name-%version.tar
Source100: vips.watch

# TODO: ImageMagick replaced by GraphicsMagick
# Patch: vips-8.14.2-alt-IM-replace-by-GM.patch

BuildRequires(pre): rpm-macros-meson
BuildRequires: meson
BuildRequires: doxygen
BuildRequires: gettext-tools
BuildRequires: perl-devel
BuildRequires: swig
BuildRequires: gcc-c++
BuildRequires: graphviz
BuildRequires: openexr-devel >= 1.2.2
BuildRequires: libImageMagick-devel
# BuildRequires: pkgconfig(GraphicsMagick)
BuildRequires: pkgconfig(matio)
BuildRequires: pkgconfig(cairo) >= 1.2
BuildRequires: pkgconfig(cfitsio)
BuildRequires: pkgconfig(expat)
BuildRequires: pkgconfig(fftw3)
BuildRequires: pkgconfig(fontconfig)
BuildRequires: pkgconfig(glib-2.0) >= 2.62
BuildRequires: pkgconfig(lcms2)
BuildRequires: pkgconfig(fftw3) >= 0.6
BuildRequires: pkgconfig(libheif) >= 1.7.0
BuildRequires: pkgconfig(libjpeg)
BuildRequires: pkgconfig(libopenjp2) >= 2.4
BuildRequires: pkgconfig(libpng) >= 1.2.9
BuildRequires: pkgconfig(libtiff-4) >= 4.0.10
BuildRequires: pkgconfig(libwebp) >= 0.6.0
BuildRequires: pkgconfig(libxml-2.0)
BuildRequires: pkgconfig(matio)
%if_enabled orc
BuildRequires: pkgconfig(orc-0.4) >= 0.4.11
%else
BuildRequires: highway-devel >= 1.0.5
%endif
BuildRequires: pkgconfig(pangoft2)
BuildRequires: pkgconfig(python3)
BuildRequires: pkgconfig(pygobject-3.0) >= 3.13.0
BuildRequires: pkgconfig(zlib)
BuildRequires: pkgconfig(libgsf-1) >= 1.14.31
BuildRequires: pkgconfig(openslide) >= 3.4.0
BuildRequires: pkgconfig(poppler-glib) >= 0.16.0
BuildRequires: pkgconfig(librsvg-2.0) >= 2.40.3
BuildRequires: pkgconfig(pango)
%ifarch x86_64 aarch64
BuildRequires: libimagequant-devel
BuildRequires: pkgconfig(libjxl)
%endif
BuildRequires: libarchive-devel
BuildRequires: libexif-devel

%{?_enable_gtk_doc:BuildRequires: gtk-doc}
%{?_enable_introspection:BuildRequires: gobject-introspection-devel}

%define majorver %(echo %version |cut -d. -f1,2)

%description
VIPS is an image processing library. It is good for very large
images (ie.  larger than the amount of RAM in your machine),
and for working with colour.  It includes a C++ API, complete
man pages, a command-line interface, automatic threading and
an operation database. There are several user interfaces built
on top of VIPS: for example "nip2".

%package -n lib%name
Summary: VIPS development kit
Group: System/Libraries

%package -n lib%name-devel
Summary: VIPS development kit
Group: Development/C
Requires: lib%name = %version-%release
Provides: %name-devel = %version-%release
Obsoletes: %name-devel < 7.16.3-alt3

%package -n lib%name-devel-doc
Summary: VIPS development kit documentation
Group: Development/C
BuildArch: noarch

%package -n lib%name-devel-static
Summary: VIPS static libraries
Group: Development/C
Requires: lib%name-devel = %version-%release
Provides: %name-devel-static = %version-%release
Obsoletes: %name-devel-static < 7.16.3-alt3

%package -n lib%name-gir
Summary: GObject introspection data for VIPS
Group: System/Libraries
Requires: %name = %EVR

%package -n lib%name-gir-devel
Summary: GObject introspection devel data for VIPS
Group: Development/Other
BuildArch: noarch
Requires: lib%name-devel = %EVR
Requires: lib%name-gir = %EVR

%description -n lib%name
Shared libraries for VIPS.

%description -n lib%name-devel
Development libraries and header files for VIPS.

%description -n lib%name-devel-doc
This package contains development documentation for VIPS.

%description -n lib%name-devel-static
Static libraries for developing statically linked VIPS applications.

%description -n lib%name-gir
GObject introspection data for VIPS.

%description -n lib%name-gir-devel
GObject introspection devel data for VIPS.

%prep
%setup

# TODO: ImageMagick replaced by GraphicsMagick
# patch0 -p1

%__subst "s|%_bindir/python$|%__python3|" tools/vipsprofile

%build
%meson \
	%if_disabled introspection
	-Dintrospection=false \
	%endif
	-Ddoxygen=true \
	-Dgtk_doc=true \
	-Dmagick-module=enabled \
	-Dmagick=enabled

%meson_build -v

%install
%meson_install

%find_lang vips%majorver
find %buildroot \( -name '*.la' -o -name '*.a' \) -exec rm -f {} ';'
# remove unneeded wrapper
rm -fv %buildroot%_bindir/vips%majorver
rm -fv %buildroot%_docdir/vips-doc/html/*.dot
rm -v %buildroot%_docdir/vips-doc/html/*.map

%files -f vips%majorver.lang
%_bindir/*
%_man1dir/*
#_docdir/vips

%files -n lib%name
%_libdir/lib*.so.*
%dir %_libdir/vips-modules-%majorver/
%_libdir/vips-modules-%majorver/vips-*.so

%files -n lib%name-devel
%_includedir/vips/
%_libdir/lib*.so
%_pkgconfigdir/*.pc

%if_enabled gtk_doc
%files -n lib%name-devel-doc
%_datadir/gtk-doc/html/*
%_docdir/vips-doc/html/*
%endif

%if_enabled static
%files -n lib%name-devel-static
%_libdir/lib*.a
%endif

%if_enabled introspection
%files -n lib%name-gir
%_typelibdir/*.typelib

%files -n lib%name-gir-devel
%_girdir/*.gir
%endif

# TODO:
# - v4l
# - package python bindings

%changelog
