%def_without govirt

Name: virt-viewer
Version: 11.0
Release: alt3

Summary: Virtual Machine Viewer
Group: System/Configuration/Other
License: GPL-2.0+
Url: https://gitlab.com/virt-viewer/virt-viewer
# Vcs https://gitlab.com/virt-viewer/virt-viewer
Source: %name-%version.tar
Patch0001: 0001-data-remove-bogus-param-for-meson-i18nmerge_file.patch

Obsoletes: spice-client < 0.12.5-alt3

Requires: libvirt-client

BuildRequires(pre): meson >= 0.54.0
BuildRequires: pkgconfig(glib-2.0) >= 2.48
BuildRequires: pkgconfig(gtk+-3.0) >= 3.18
BuildRequires: pkgconfig(libxml-2.0) >= 2.6.0
BuildRequires: pkgconfig(libvirt) >= 1.2.8
BuildRequires: pkgconfig(libvirt-glib-1.0) >= 0.1.8
BuildRequires: pkgconfig(gtk-vnc-2.0) >= 0.4.0
BuildRequires: pkgconfig(spice-client-gtk-3.0) >= 0.35
BuildRequires: pkgconfig(spice-protocol) >= 0.12.7
BuildRequires: pkgconfig(vte-2.91) >= 0.46.0
BuildRequires: /usr/bin/pod2man
BuildRequires: gettext
%{?_with_govirt:BuildRequires: pkgconfig(govirt-1.0) >= 0.3.7 pkgconfig(rest-0.7) >= 0.8}
BuildRequires: bash-completion

%description
Virt Viewer provides a graphical viewer for the guest OS
display. At this time is supports guest OS using the VNC
or SPICE protocols. Further protocols may be supported in
the future as user demand dicatates. The viewer can connect
directly to both local and remotely hosted guest OS, optionally
using SSL/TLS encryption.

%prep
%setup
%patch0001 -p1

%build
%meson -Dbuild-id=%release -Dos-id=ALT
%meson_build

%install
%meson_install
%find_lang %name

%files -f %name.lang
%doc README.md COPYING NEWS
%_bindir/*
%_man1dir/*
%_datadir/mime/packages/*.xml
%_desktopdir/*.desktop
%_datadir/metainfo/remote-viewer.appdata.xml
%_iconsdir/hicolor/*/apps/*
%_datadir/bash-completion/completions/virt-viewer

%changelog
