%define oldmodname kernel-source-virtualbox
%define oldmodnamenetflt kernel-source-virtualbox-netfilter
%define oldmodnamenetadp kernel-source-virtualbox-netadaptor
%define oldmodnameadd kernel-source-virtualbox-addition
%define oldmodnameguest kernel-source-virtualbox-guest
%define oldmodnamevfs kernel-source-virtualbox-vfs
%define oldmodnamevideo kernel-source-virtualbox-video

%define modname kernel-source-vboxdrv
%define modnamepci kernel-source-vboxpci
%define modnamenetflt kernel-source-vboxnetflt
%define modnamenetadp kernel-source-vboxnetadp
%define modnameguest kernel-source-vboxguest
%define modnamevfs kernel-source-vboxsf
%define modnamevideo kernel-source-vboxvideo

%define distname VirtualBox
%define distarchive %distname-%{version}_OSE

%define optflagsN -O -g

%def_disable debug

%def_with manual
%def_without manualbuild
%def_without manualchm
%def_without manualsdk
%def_with additions
%def_with webservice
%def_without java
%def_with vnc
%def_with vde
%def_with libvpx
%def_without python
%def_without vboxpci
%def_with vboximg

%ifarch %ix86
%define vbox_platform linux.x86
%endif
%ifarch x86_64
%define vbox_platform linux.amd64
%endif

%if_enabled debug
%define vboxdir %_builddir/%distarchive/out/%vbox_platform/release/bin
%define vboxdbg vbox-debug.sh
%define vboxdbg_file %_builddir/%distarchive/%vboxdbg
%else
%define vboxdir %_libdir/virtualbox
%endif

%if_with webservice
%define vboxwebdir %_localstatedir/vboxwebsrv
%endif

%define vboxdatadir %_datadir/virtualbox
%define ld_so_confdir %_sysconfdir/ld.so.conf.d
%define ld_so_conf %ld_so_confdir/%name-%_arch.conf

%filter_from_provides '/^lib[E]\\?GL\\.so\\./d'

%set_verify_elf_method textrel=relaxed
%add_findprov_lib_path %vboxdir


Name: virtualbox
Version: 7.2.0
Release: alt1

Summary: VM VirtualBox OSE - Virtual Machine for x86 hardware
License: GPLv2
Group: Emulators
Url: http://www.virtualbox.org/

ExclusiveArch: %ix86 x86_64

BuildRequires(pre): rpm-build-ubt

Source: %distarchive.tar

Source1:	%name.control.in
Source2:	%name.init
Source3:	%name-addition.rules
Source4:	%name.rules
Source5:	60-vboxadd.perms
Source6:	vboxadd-service.sysconfig
Source8:	vboxadd-service.init
Source9:	vboxweb-service.sysconfig
Source10:	vboxweb-service.init
Source15:	os_altlinux.png
Source16:	os_altlinux_64.png
Source22:	%name.service
Source23:	virtualbox.conf
Source25:	virtualbox-vboxvideo.modprobe.conf
Source26:	virtualbox-vboxguest.modprobe.conf
Source27:	virtualbox-vmsvga.service
Source28:	virtualbox-addition.conf
Source29:	virtualbox-vboxsf.modprobe.conf
Source30:	vboxadd-service.service
Source31:	virtualbox.role
Source32:	virtualbox-addition.role

%if_with manual
%if_without manualbuild
Source100:	UserManual-%version.pdf
%endif
%endif

%if_enabled debug
Source99:	%vboxdbg.in
%endif

Patch:		%name-%version-alt.patch
Patch10:	http-curl.patch

BuildPreReq: iasl gcc-c++ libstdc++-devel-static
BuildPreReq: libIDL-devel libSDL-devel libpng-devel libSDL2-devel-static
BuildPreReq: libXcursor-devel libXext-devel
BuildPreReq: xsltproc
BuildPreReq: rpm-build-kernel
BuildPreReq: rpm-macros-qt6
BuildRequires: genisoimage
BuildRequires: docbook-dtds
BuildPreReq: libpulseaudio-devel
BuildRequires: libdevmapper-devel
BuildRequires: makeself
BuildRequires: qt6-tools
BuildRequires: qt6-connectivity-devel
BuildRequires: qt6-declarative-devel
BuildRequires: qt6-multimedia-devel
BuildRequires: qt6-phonon-devel
BuildRequires: qt6-base-devel
BuildRequires: qt6-sensors-devel
BuildRequires: qt6-serialbus-devel
BuildRequires: qt6-scxml-devel

BuildRequires: libopus-devel
BuildRequires: libssl-devel
BuildRequires: libxml2-devel libxslt-devel
BuildRequires: qt6-base-devel libalsa-devel
BuildRequires: libcap-devel libcurl-devel
BuildRequires: libXmu-devel libGLU-devel
BuildRequires: libXinerama-devel libXrandr-devel
BuildRequires: libXdamage-devel libXcomposite-devel libXcomposite
BuildRequires: xorg-xf86driproto-devel xorg-glproto-devel
BuildRequires: xorg-resourceproto-devel xorg-scrnsaverproto-devel
BuildRequires(pre): xorg-sdk
BuildPreReq: yasm >= 1.3.0
BuildPreReq: kBuild >= 0.1.9998.r3592
BuildRequires: glslang-devel
BuildRequires: qt6-tools-devel
BuildRequires: python3-module-packaging
BuildRequires: libavcodec-devel

%if_with webservice
BuildRequires: libgsoap-devel libgsoap-devel-static > 2.8.0
%endif
%if_with python
BuildRequires: python3-dev
BuildRequires(pre): rpm-build-python3
%add_python3_path %vboxdir
%add_python3_req_skip xpcom._xpcom
%endif
BuildRequires: libpam-devel
%if_with manualbuild
BuildRequires: texlive-latex-recommended
BuildRequires: texlive-fontsextra texlive-texmf
BuildRequires: docbook-style-xsl
BuildRequires: /usr/bin/chmcmd
%endif
%if_with manualchm
BuildRequires: i586-wine-vanilla
%endif
%if_with vnc
BuildRequires: libvncserver-devel
%endif
%if_with libvpx
BuildRequires: libvpx-devel
%endif
BuildRequires: rpm-build-xdg rpm-macros-pam
BuildRequires: /proc
Requires(pre,postun): %name-common = %version-%release

%description
VirtualBox is a powerful PC virtualization solution allowing
you to run a wide range of PC operating systems on your Linux
system. This includes Windows, Linux, FreeBSD, DOS, OpenBSD
and others. VirtualBox comes with a broad feature set and
excellent performance, making it the premier virtualization
software solution on the market.

%package guest-additions
Summary: Full package of additions for VirtualBox OSE guest systems
Group: Emulators
Requires: %name-guest-utils
Provides: %name-guest-additions-gl = %version-%release
Obsoletes: %name-guest-additions-gl < %version-%release

%description guest-additions
This packages contains full package of additions for VirtualBox OSE
guest systems. It consists basic utils, which allows to share files and
sync time with host system, and intergrates with xorg-server for mouse
and video driver with OpenGL support, copy/paste between guest and host.

%package guest-utils
Summary: Additions tools for VirtualBox OSE guest systems
Group: Emulators
Requires: %name-guest-common = %version-%release

%description guest-utils
This packages contains basic utils for VirtualBox OSE guest systems.
It allows to share files and sync time with host system.

%package guest-common
Summary: Additions common files for VirtualBox OSE guest systems
Group: Emulators

# for automatic adding group vboxadd (and vboxsf) to system roles (users, powerusers, localadmins)
Requires: libnss-role >= 0.5.1

# https://bugzilla.altlinux.org/42576
Provides: %name-guest-common-vboxvideo = %EVR
Obsoletes: %name-guest-common-vboxvideo < %EVR
Provides: %name-guest-common-vboxguest = %EVR
Obsoletes: %name-guest-common-vboxguest < %EVR
Provides: %name-guest-common-vboxsf = %EVR
Obsoletes: %name-guest-common-vboxsf < %EVR

%description guest-common
This packages contains common files for VirtualBox OSE guest systems.
It consists modprobe rules to load kernel modules guest on guest system.

%package webservice
Summary: VirtualBox Web Service
Group: Emulators
Requires: %name = %version-%release

%description webservice
This packages contains VirtualBox web service API daemon.
It allows to control virtual machines via web interface.

%package -n python3-module-vboxapi
Summary: VirtualBox python API
Group: Development/Python
Requires: %name = %version-%release

%description -n python3-module-vboxapi
This packages contains VirtualBox python module 'vboxapi'.
It allows to control virtual machines via python scripts.

%package -n %modname
Summary: Sources for VirtualBox module
Group: Development/Kernel
Provides: %oldmodname = %version-%release

%description -n %modname
Sources for VirtualBox kernel module.

%package -n %modnamepci
Summary: Sources for VirtualBox module for OSE pci
Group: Development/Kernel

%description -n %modnamepci
Sources for VirtualBox kernel module for OSE pci.

%package -n %modnamenetflt
Summary: Sources for VirtualBox module for OSE netfilter
Group: Development/Kernel
Provides: %oldmodnamenetflt = %version-%release

%description -n %modnamenetflt
Sources for VirtualBox kernel module for OSE netfilter.

%package -n %modnamenetadp
Summary: Sources for VirtualBox module for OSE netadaptor
Group: Development/Kernel
Provides: %oldmodnamenetadp = %version-%release

%description -n %modnamenetadp
Sources for VirtualBox kernel module for OSE netadaptor.

%package -n %modnameguest
Summary: Sources for VirtualBox module for OSE guest additions
Group: Development/Kernel
BuildArch: noarch
Provides: %oldmodnameadd = %version-%release
Provides: %oldmodnameguest = %version-%release

%description -n %modnameguest
Sources for VirtualBox kernel module for OSE guest additions.

%package -n %modnamevfs
Summary: Sources for VirtualBox module for OSE VFS
Group: Development/Kernel
BuildArch: noarch
Provides: %oldmodnamevfs = %version-%release

%description -n %modnamevfs
Sources for VirtualBox kernel module for OSE VFS.

%package -n %modnamevideo
Summary: Sources for VirtualBox module for OSE Video DRM
Group: Development/Kernel
BuildArch: noarch
Provides: %oldmodnamevideo = %version-%release

%description -n %modnamevideo
Sources for VirtualBox kernel module for OSE Video DRM.

%package common
Summary: VirtualBox module support files
Group: System/Configuration/Other
# due to new_summary function and is_builtin_mode bugfix
Requires(pre,postun): control >= 0.7.2-alt1
Requires(pre,postun): shadow-utils
# due to /bin/mountpoint
Requires(pre,postun): sysvinit-utils
# for automatic adding group vboxusers to system roles (users, powerusers, localadmins)
Requires: libnss-role >= 0.5.1

%description common
This package contains scripts and other support files which are
required to use the vboxdrv kernel module in the ALT Linux system.
The kernel module itself is not included - you need to install the
appropriate kernel-modules-virtualbox-* package for your kernel.

%package doc
Summary: VirtualBox documentation
Group: Documentation
Requires: %name = %version-%release

%description doc
This package contains VirtualBox User Manual.

%package sdk
Summary: VirtualBox SDK
Group: Development/Other
%if_with python
Requires: python3-module-vboxapi = %version-%release
%endif

%description sdk
This package contains VirtualBox SDK.

%package sdk-xpcom
Summary: VirtualBox SDK XPCOM
Group: Development/Other
Requires: %name-sdk = %EVR

%description sdk-xpcom
This package contains VirtualBox SDK for XPCOM.

%prep
%setup -q -n %distarchive
%patch -p1
%patch10 -p2

cp %SOURCE15 %SOURCE16 src/VBox/Frontends/VirtualBox/images

# fix python shebang for scripts
grep -R '^#!/usr/bin/\(env[[:space:]]\+\)\?python' src | cut -d: -f1 |
    while read f; do
        sed -E -i '1 s@^(#![[:space:]]*)%_bindir/(env[[:space:]]+)?python$@\1%__python3@' "$f"
    done

%build
./configure --ose \
    --with-makeself="/usr/bin/makeself.sh" \
    --disable-kmods \
    --with-yasm="%_bindir/yasm" \
%if_with webservice
    --enable-webservice \
%endif
%if_without python
    --disable-python \
%endif
%if_without java
    --disable-java \
%endif
%if_with vnc
    --enable-vnc \
%endif
%if_with vde
    --enable-vde \
%endif
%if_without libvpx
    --disable-libvpx \
%endif
%if_without manualbuild
    --disable-docs \
%endif
%if_with manualchm
    --setup-wine \
%endif
%ifarch x86_64
    --disable-vmmraw \
%endif
    --enable-qt6 \

kbuild=%_bindir

%if_without additions
echo "VBOX_WITH_X11_ADDITIONS    := " >> LocalConfig.kmk
%endif
# don't build testcases to save time, they are not needed for the package
echo "VBOX_WITH_TESTCASES        :=" >> LocalConfig.kmk
echo "VBOX_WITH_TESTSUITE        :=" >> LocalConfig.kmk
# required for VBOX_PATH_APP_PRIVATE_*
echo "VBOX_DOCBOOK_WITH_LATEX    := 1" >> LocalConfig.kmk
echo "KBUILD_MSG_STYLE           := brief" >> LocalConfig.kmk
echo "VBOX_PATH_APP_PRIVATE_ARCH := %vboxdir" >> LocalConfig.kmk
echo "VBOX_PATH_SHARED_LIBS      := \$(VBOX_PATH_APP_PRIVATE_ARCH)" >> LocalConfig.kmk
echo "VBOX_WITH_RUNPATH          := \$(VBOX_PATH_APP_PRIVATE_ARCH)" >> LocalConfig.kmk
echo "VBOX_PATH_APP_PRIVATE      := %vboxdatadir" >> LocalConfig.kmk
echo "VBOX_PATH_APP_DOCS         := %_defaultdocdir/%name-doc-%version" >> LocalConfig.kmk
echo "VBOX_PATH_PACKAGE_DOCS     := \$(VBOX_PATH_APP_DOCS)" >> LocalConfig.kmk
echo "VBOX_VENDOR                := ALT Linux Team" >> LocalConfig.kmk
echo "VBOX_VENDOR_SHORT          := ALT" >> LocalConfig.kmk
echo "VBOX_PRODUCT               := VM VirtualBox OSE" >> LocalConfig.kmk
echo "VBOX_WITH_VBOXSDL          := 1" >> LocalConfig.kmk
echo "VBOX_WITH_WEBSERVICES      := 1" >> LocalConfig.kmk
echo "VBOX_GSOAP_INSTALLED       := 1" >> LocalConfig.kmk

# disable build with bundled xorg/mesa headers
echo "VBOX_USE_SYSTEM_XORG_HEADERS := 1" >> LocalConfig.kmk
echo "VBOX_USE_SYSTEM_GL_HEADERS := 1" >> LocalConfig.kmk
# do not build legacy xorg driver
echo "VBOX_NO_LEGACY_XORG_X11 := 1" >> LocalConfig.kmk

echo "VBOX_WITH_REGISTRATION_REQUEST :=" >> LocalConfig.kmk
echo "VBOX_WITH_UPDATE_REQUEST :=" >> LocalConfig.kmk
echo "KBUILD_VERBOSE := 2" >> LocalConfig.kmk
echo "VBOX_WITH_EXTPACK_VBOXDTRACE :=" >> LocalConfig.kmk
%if_with vboxpci
echo "VBOX_WITH_PCI_PASSTHROUGH := 1" >> LocalConfig.kmk
%endif

# respect RPM optflags
echo "TOOL_GCC3_CFLAGS := %optflagsN" >> LocalConfig.kmk
echo "TOOL_GCC3_CXXFLAGS := %optflagsN" >> LocalConfig.kmk
echo "VBOX_GCC_OPT := %optflagsN" >> LocalConfig.kmk
%if_with manualsdk
echo "VBOX_WITH_DOCS_SDKREF      := 1" >> LocalConfig.kmk
%endif
%if_without manualsdk
echo "VBOX_WITH_DOCS_SDKREF      :=" >> LocalConfig.kmk
%endif
%if_with manualchm
echo "VBOX_WITH_DOCS_CHM         := 1" >> LocalConfig.kmk
echo "VBOX_CHMCMD                := 1" >> LocalConfig.kmk
%endif
%if_without manualchm
echo "VBOX_WITH_DOCS_CHM         :=" >> LocalConfig.kmk
echo "VBOX_CHMCMD                :=" >> LocalConfig.kmk
%endif
%if_with vboximg
echo "VBOX_WITH_VBOX_IMG         := 1" >> LocalConfig.kmk
%endif

echo "VBOX_PATH_DOCBOOK          := /usr/share/xml/docbook/xsl-stylesheets" >> LocalConfig.kmk
echo "VBOX_PATH_DOCBOOK_DTD      := /usr/share/xml/docbook/dtd/4.5" >> LocalConfig.kmk
echo "VBOX_WITH_DOCS_PDF         :=" >> LocalConfig.kmk

#source env.sh
[ -n "$NPROCS" ] || NPROCS=%__nprocs
# Set NPROCS=1 due build server constraints:
# https://lists.altlinux.org/pipermail/devel/2018-July/204964.html

NPROCS=1; kmk -j$NPROCS  VBOXDIR=%vboxdir

%if_enabled debug
sed 's|@VBOX_BUILD_DIR@|%vboxdir|g' %SOURCE99 >%vboxdbg_file
chmod u+x %vboxdbg_file
%endif

%install
%if_enabled debug
echo -e "\nVirtualBox not installable due debug build enabled\nRun: %vboxdbg_file\n  or %vboxdbg_file ./VirtualBox\n"
false
%endif

mkdir -p %buildroot{%_bindir,%_sbindir,%vboxdir/ExtensionPacks,%vboxdatadir,%kernel_src,%_initrddir,%_udevrulesdir}

%ifarch x86_64
# install common
install -Dp %SOURCE1 %buildroot%_controldir/%name
sed -i -e 's|@udevrulesdir@|%_udevrulesdir|g' %buildroot%_controldir/%name
install -Dp %SOURCE2 %buildroot%_initdir/%name
%if_without vboxpci
sed -i -n '/action .* modprobe --syslog $MODULENAMEPCI/!p' %buildroot%_initdir/%name
%endif
install -Dp -m644 %SOURCE4 \
	%buildroot%_udevrulesdir/90-%name.rules
install -Dp -m644 %SOURCE31 %buildroot%_sysconfdir/role.d/virtualbox.role
%endif

%if_with additions
# install additions from src
install -Dp %SOURCE8 %buildroot%_initdir/vboxadd-service
install -Dp -m644 %SOURCE30 %buildroot%_unitdir/vboxadd-service.service
install -Dp -m644 %SOURCE3 %buildroot%_udevrulesdir/60-vboxadd.rules

#install -d %buildroot%_sysconfdir/hal/fdi/policy
#install -m644 src/VBox/Additions/linux/installer/90-vboxguest.fdi %buildroot%_sysconfdir/hal/fdi/policy/90-vboxguest.fdi

# Install VBoxClient-all in /usr/bin/
install -d %buildroot%_bindir
install -m755 src/VBox/Additions/x11/Installer/98vboxadd-xclient %buildroot%_bindir/VBoxClient-all
install -Dp -m644  src/VBox/Additions/x11/Installer/vboxclient.desktop %buildroot%_sysconfdir/xdg/autostart/vboxclient.desktop


# Creating a symlink 98vboxadd-xclient -> VBoxClient-all in /etc/X11/xinit.d/
#install -d %buildroot%_sysconfdir/X11/xinit.d
#ln -s %_bindir/VBoxClient-all %buildroot%_sysconfdir/X11/xinit.d/98vboxadd-xclient

%endif

# install application
cd out/%vbox_platform/release/bin

%ifarch x86_64
cp -a \
    VBoxAutostart \
    VBoxBalloonCtrl \
    VBoxExtPackHelperApp \
    VBoxHeadless \
    VBoxManage \
    VBoxNetNAT \
    VBoxNetAdpCtl \
    VBoxNetDHCP \
    VBoxSDL \
    VBoxSVC \
    VBoxVolInfo \
    VirtualBox \
    VirtualBoxVM \
    VBoxVMMPreload \
    xpidl \
    *.r0 \
%ifarch %ix86
    *.rc \
%endif
    *.so \
    *.fd \
%if_with python
    *.py \
%endif
    components/ \
%if_with webservice
    vboxwebsrv \
%endif
    vboximg-mount \
%if_with vboximg
    vbox-img \
%endif
    %buildroot%vboxdir

find sdk -maxdepth 1 -mindepth 1 -not -name docs -print0 | xargs -0 cp -R --target-directory=%buildroot%vboxdir --parents

cd ../../../../include/
mkdir -p %buildroot%_includedir
for d in iprt VBox/com; do
	cp -R --target-directory=%buildroot%_includedir --parents $d
done
cd -

%if_with python
cd sdk/installer >/dev/null
  VBOX_INSTALL_PATH=%vboxdir VBOX_VERSION=%version %__python3 vboxapisetup.py install --install-lib=%python3_sitelibdir --root=%buildroot
cd -
%endif

cp -a \
    VBoxCreateUSBNode.sh \
    nls/ \
    %buildroot%vboxdatadir

# create links
for n in VBoxAutostart \
         VBoxBalloonCtrl \
         VBoxHeadless \
         VBoxManage \
         VBoxSDL \
         VBoxVolInfo \
         VirtualBoxVM \
         VirtualBox; do
    ln -s $n %buildroot%vboxdir/$(echo $n | tr A-Z a-z)
done
for n in VBoxAutostart \
         vboxautostart \
         VBoxBalloonCtrl \
         vboxballoonctrl \
         VBoxManage \
         vboxmanage \
         VBoxSDL \
         vboxsdl \
         VBoxVolInfo \
         vboxvolinfo \
         VirtualBox \
         VirtualBoxVM \
         virtualbox \
%if_with webservice
         vboxwebsrv \
%endif
         vboximg-mount \
%if_with vboximg
         vbox-img \
%endif
         xpidl; do
    ln -s $(relative %vboxdir/$n %_bindir/$n) %buildroot%_bindir
done

# remove breaked symlink to deleted module
rm -f %buildroot%vboxdir/components/VBoxREM.so

# install kernel sources
cp -a src/vboxdrv %buildroot%kernel_src/%modname-%version
%if_with vboxpci
cp -a src/vboxpci %buildroot%kernel_src/%modnamepci-%version
%endif
cp -a src/vboxnetflt %buildroot%kernel_src/%modnamenetflt-%version
cp -a src/vboxnetadp %buildroot%kernel_src/%modnamenetadp-%version
tar -C %buildroot%kernel_src -c %modname-%version | bzip2 -c > \
    %buildroot%kernel_src/%modname-%version.tar.bz2
rm -rf %buildroot%kernel_src/%modname-%version
%if_with vboxpci
tar -C %buildroot%kernel_src -c %modnamepci-%version | bzip2 -c > \
    %buildroot%kernel_src/%modnamepci-%version.tar.bz2
rm -rf %buildroot%kernel_src/%modnamepci-%version
%endif
tar -C %buildroot%kernel_src -c %modnamenetflt-%version | bzip2 -c > \
    %buildroot%kernel_src/%modnamenetflt-%version.tar.bz2
rm -rf %buildroot%kernel_src/%modnamenetflt-%version
tar -C %buildroot%kernel_src -c %modnamenetadp-%version | bzip2 -c > \
    %buildroot%kernel_src/%modnamenetadp-%version.tar.bz2
rm -rf %buildroot%kernel_src/%modnamenetadp-%version
%endif

cd additions >/dev/null
# install additions kernel sources
  cp -a src/vboxguest %buildroot%kernel_src/%modnameguest-%version
  tar -C %buildroot%kernel_src -c %modnameguest-%version | bzip2 -c > \
    %buildroot%kernel_src/%modnameguest-%version.tar.bz2
  rm -rf %buildroot%kernel_src/%modnameguest-%version

# install VFS kernel sources
  cp -a src/vboxsf %buildroot%kernel_src/%modnamevfs-%version
  tar -C %buildroot%kernel_src -c %modnamevfs-%version | bzip2 -c > \
    %buildroot%kernel_src/%modnamevfs-%version.tar.bz2
  rm -rf %buildroot%kernel_src/%modnamevfs-%version

# install VFS kernel sources
  cp -a src/vboxvideo %buildroot%kernel_src/%modnamevideo-%version
  tar -C %buildroot%kernel_src -c %modnamevideo-%version | bzip2 -c > \
    %buildroot%kernel_src/%modnamevideo-%version.tar.bz2
  rm -rf %buildroot%kernel_src/%modnamevideo-%version

%if_with additions
# install additions
  install -d %buildroot/%_bindir
  install -m755 VBoxClient VBoxControl VBoxDRMClient VBoxService vboxwl %buildroot/%_bindir/

# install roles
  install -Dpm644 %SOURCE32 %buildroot%_sysconfdir/role.d/virtualbox-addition.role

# create links
  ln -s $(relative %_bindir/VBoxService %_sbindir/) %buildroot%_sbindir/vboxadd-service

# install sysconfig for vboxadd-service
  mkdir -p %buildroot%_sysconfdir/sysconfig
  cp %SOURCE6 %buildroot%_sysconfdir/sysconfig/vboxadd-service

# install mount vbox share folder
  install -d %buildroot/sbin
  install -m755 mount.vboxsf %buildroot/sbin/mount.vboxsf

  install -d %buildroot%_sysconfdir/security/console.perms.d/
  install -m644 %SOURCE5 %buildroot%_sysconfdir/security/console.perms.d/

  install -d %buildroot%_unitdir/
  install -m644 %SOURCE27 %buildroot%_unitdir/

  mkdir -p %buildroot%_pam_modules_dir/
  install -m644 pam_vbox.so %buildroot%_pam_modules_dir/
%endif
cd - >/dev/null

%ifarch x86_64
# install icons
mkdir -p %buildroot%_niconsdir
install -m644 icons/32x32/*.png %buildroot%_niconsdir/
mkdir -p %buildroot%_miconsdir
install -m644 icons/16x16/*.png %buildroot%_miconsdir/
mkdir -p %buildroot%_liconsdir
install -m644 icons/48x48/*.png %buildroot%_liconsdir/
mkdir -p %buildroot%_iconsdir/hicolor/64x64/apps
install -m644 icons/64x64/*.png %buildroot%_iconsdir/hicolor/64x64/apps/
mkdir -p %buildroot%_iconsdir/hicolor/128x128/apps
install -m644 icons/128x128/*.png %buildroot%_iconsdir/hicolor/128x128/apps/

# install mime types
mkdir -p %buildroot%_xdgmimedir/packages
install -m644 virtualbox.xml %buildroot%_xdgmimedir/packages/virtualbox.xml

# install menu entries
mkdir -p %buildroot%_desktopdir
install -m644 %name.desktop %buildroot%_desktopdir/
sed -i 's|^DocPath=|#DocPath=|' %buildroot%_desktopdir/%name.desktop

# install docs
mkdir -p %buildroot%_defaultdocdir/%name-doc-%version
%if_with manual
%if_with manualbuild
install -m644 UserManual.pdf %buildroot%_defaultdocdir/%name-doc-%version/
cp -r ../obj/manual/en_US/qhelp/* %buildroot%_defaultdocdir/%name-doc-%version/
%endif
%if_with manualchm
install -m644 VirtualBox.chm %buildroot%_defaultdocdir/%name-doc-%version/
%endif
%if_with manualsdk
find sdk/docs -maxdepth 1 -mindepth 1 -print0 | xargs -0 -i install -m644 {} %buildroot%_defaultdocdir/%name-doc-%version/
%endif
%if_without manualbuild
install -m644 %SOURCE100 %buildroot%_defaultdocdir/%name-doc-%version/UserManual.pdf
%endif
%endif

# install unit file
install -pDm644 %SOURCE22 %buildroot%_unitdir/%name.service
install -pDm644 %SOURCE23 %buildroot%_sysconfdir/modules-load.d/%name.conf
%if_without vboxpci
sed -i -n '/vboxcpi/!p' %buildroot%_unitdir/%name.service
sed -i -n '/vboxcpi/!p' %buildroot%_sysconfdir/modules-load.d/%name.conf
%endif

%if_with vnc
 cp -a ExtensionPacks/VNC %buildroot%vboxdir/ExtensionPacks/
%endif

%if_with webservice
  mkdir -p %buildroot%vboxwebdir

# install vboxweb-service initscript
  install -Dp %SOURCE10 %buildroot%_initdir/vboxweb-service

# install sysconfig for vboxweb-service
  mkdir -p %buildroot%_sysconfdir/sysconfig
  cp %SOURCE9 %buildroot%_sysconfdir/sysconfig/vboxweb-service
%endif
%endif

%pre
%pre_control %name

%post
%post_control -s vboxusers %name
%post_service virtualbox

%preun
%preun_service virtualbox

%post doc
sed -i 's|^#DocPath=|DocPath=|' %_desktopdir/%name.desktop
XDG_DATA_DIRS="%_datadir" update-desktop-database -q ||:

%preun doc
sed -i 's|^DocPath=|#DocPath=|' %_desktopdir/%name.desktop
XDG_DATA_DIRS="%_datadir" update-desktop-database -q ||:

%pre common
%pre_control %name
/usr/sbin/groupadd -r -f vboxusers

%post common
%post_service %name
%post_control -s vboxusers %name

%preun common
%preun_service %name

%triggerin common -- dev
# If using static /dev, select the same status again to fix permissions
mountpoint -q /dev || {
	status="`/usr/sbin/control %name status`" || status=
	[ -n "$status" ] && /usr/sbin/control %name "$status" ||:
}

%pre guest-common
/usr/sbin/groupadd -r -f vboxadd
/usr/sbin/groupadd -r -f vboxsf

%if_with webservice
%pre webservice
/usr/sbin/useradd -r -g vboxusers -d %vboxwebdir -c 'VirtualBox Web Service' -n vboxwebsrv -s /bin/sh >/dev/null 2>&1 ||:
%endif

%ifarch x86_64
%files
%_bindir/*
%vboxdir/*
%exclude %_bindir/VBoxClient-all
%exclude %_bindir/VBoxDRMClient
%exclude %_bindir/xpidl
%if_with additions
%exclude %_bindir/VBoxClient
%exclude %_bindir/VBoxControl
%exclude %_bindir/VBoxService
%exclude %_bindir/vboxwl
%endif
%if_with webservice
%exclude %_bindir/vboxwebsrv
%exclude %vboxdir/vboxwebsrv
%endif
%dir %vboxdir
%dir %vboxdir/ExtensionPacks
%attr(4710,root,vboxusers) %vboxdir/VBoxExtPackHelperApp
%attr(4710,root,vboxusers) %vboxdir/VBoxHeadless
%attr(4710,root,vboxusers) %vboxdir/VBoxNetDHCP
%attr(4710,root,vboxusers) %vboxdir/VBoxNetNAT
%attr(4710,root,vboxusers) %vboxdir/VBoxNetAdpCtl
%attr(4710,root,vboxusers) %vboxdir/VBoxSDL
%attr(4710,root,vboxusers) %vboxdir/VBoxVolInfo
%attr(4710,root,vboxusers) %vboxdir/VirtualBoxVM
%vboxdir/VirtualBox
%exclude %vboxdir/sdk
%exclude %vboxdir/xpidl
%if_with python
%exclude %vboxdir/VBoxPython*.so
%endif
%vboxdatadir/nls
%_niconsdir/*.png
%_miconsdir/*.png
%_liconsdir/*.png
%_iconsdir/hicolor/64x64/apps/*.png
%_iconsdir/hicolor/128x128/apps/*.png
%_xdgmimedir/packages/*.xml
%_desktopdir/*.desktop

%files -n %modname
%kernel_src/%modname-%version.tar.bz2

%if_with vboxpci
%files -n %modnamepci
%kernel_src/%modnamepci-%version.tar.bz2
%endif

%files -n %modnamenetflt
%kernel_src/%modnamenetflt-%version.tar.bz2

%files -n %modnamenetadp
%kernel_src/%modnamenetadp-%version.tar.bz2
%endif

%files -n %modnameguest
%kernel_src/%modnameguest-%version.tar.bz2

%files -n %modnamevfs
%kernel_src/%modnamevfs-%version.tar.bz2

%files -n %modnamevideo
%kernel_src/%modnamevideo-%version.tar.bz2

%if_with additions
%files guest-common
%config(noreplace) %_sysconfdir/role.d/virtualbox-addition.role

%files guest-utils
/sbin/mount.vboxsf
%_initrddir/vboxadd-service
%config(noreplace) %_sysconfdir/sysconfig/vboxadd-service
%config %_udevrulesdir/60-vboxadd.rules
%_sbindir/vboxadd-service
%_unitdir/vboxadd-service.service
%_bindir/VBoxControl
%_bindir/VBoxService
%_pam_modules_dir/*.so
%_sysconfdir/security/console.perms.d/60-vboxadd.perms

%files guest-additions
%_sysconfdir/xdg/autostart/vboxclient.desktop
%_unitdir/virtualbox-vmsvga.service
%_bindir/VBoxClient-all
%_bindir/VBoxClient
%_bindir/VBoxDRMClient
%_bindir/vboxwl
%endif

%ifarch x86_64
%if_with webservice
%files webservice
%_initrddir/vboxweb-service
%config(noreplace) %_sysconfdir/sysconfig/vboxweb-service
%dir %attr(0750,vboxwebsrv,vboxusers) %vboxwebdir
%vboxdir/vboxwebsrv
%_bindir/vboxwebsrv
%endif

%if_with python
%files -n python3-module-vboxapi
%vboxdir/VBoxPython*.so
%python3_sitelibdir/*
%vboxdir/sdk/bindings/xpcom/python/xpcom
%endif

%files common
%_initdir/%name
%_unitdir/%name.service
%_controldir/%name
%config %_udevrulesdir/90-%name.rules
%dir %vboxdatadir
%vboxdatadir/VBoxCreateUSBNode.sh
%config %_sysconfdir/modules-load.d/%name.conf
%config(noreplace) %_sysconfdir/role.d/virtualbox.role

%if_with manual
%files doc
%_defaultdocdir/%name-doc-%version
%endif

%files sdk
%_bindir/xpidl
%vboxdir/xpidl
%vboxdir/sdk
%if_with python
%exclude %vboxdir/sdk/bindings/xpcom/python/xpcom
%endif

%files sdk-xpcom
%_includedir/iprt
%_includedir/VBox/com
%endif

%changelog
