# SPEC file for vnStat package

Name:    vnstat
Version: 2.12
Release: alt1

Summary: console-based network traffic monitor
Summary(ru_RU.UTF-8): консольная утилита для подсчёта трафика

License: %gpl2only
Group:   Monitoring
URL:     http://humdi.net/vnstat/

Packager: Nikolay A. Fetisov <naf@altlinux.org>

Source0: %name-%version.tar
Patch0:  %name-%version-%release.patch

Source1: %name.control
Source2: %{name}d.init
Source3: %{name}d.tmpfiles

BuildRequires(pre): rpm-build-licenses

# Automatically added by buildreq on Thu May 09 2019
# optimized out: fontconfig gem-power-assert glibc-kernheaders-generic glibc-kernheaders-x86 gnu-config pkg-config python-base python-modules python3 python3-base python3-dev ruby ruby-coderay ruby-method_source ruby-pry ruby-rake ruby-rdoc ruby-stdlibs sh4 tzdata
BuildRequires: libgd3-devel libsqlite3-devel

%define data_dir     %_localstatedir/%name
%define piddir       /var/run/%{name}d

%description
vnStat  is a console-based network  traffic monitor that keeps a log
of daily network traffic for the selected interface(s). vnStat isn't
a packet sniffer. The traffic information is analyzed from the /proc
filesystem. vnStat runs under unprivileged user account and does not
need any system's tuning, but can account only a total interface's
traffic with some issues on accuracy.

%description -l ru_RU.UTF-8
vnStat собирает и выводит статистику потребления трафика.
Для получения информации он использует файловую систему /proc.

Достоинством такого подхода является возможность собирать информацию
с привилегиями рядового пользователя. С другой стороны, при этом не
учитываются такие подробности, как IP-адреса клиентов, типы соединений
и т.д. Отчёты содержат только общее количество принятых и переданных
байт, упорядоченное по периодам времени и сетевым интерфейсам.

Утилита vnstat предназначена как для вывода статистики из базы данных,
собираемой сервером vnstatd из пакета %{name}-server, так и без сервера
vnstatd для интерактивного сбора и вывод данных по конкретному
сетевому интерфейсу.

%package server
Summary: optional server for vnstat network traffic monitor
#Summary(ru_RU.UTF-8): 
Group:   Monitoring
Requires: %name = %version-%release

%description server
vnStat  is a console-based network  traffic monitor that keeps a log
of daily network traffic for the selected interface(s).

This package contains optional standalone server for vnstat network
traffice monitor.

%package  vnstati
Summary: optional png image output support for vnstat
Group:   Monitoring
Requires: %name = %version-%release

%description vnstati
vnStat  is a console-based network  traffic monitor that keeps a log
of daily network traffic for the selected interface(s).

This package contains optional vnstati utility to provide PNG image
output support for statistics collected using vnstat.

%prep
%setup -q
%patch0 -p1

mv -f -- COPYING COPYING.orig
ln -s -- $(relative %_licensedir/GPL-2 %_docdir/%name/COPYING) COPYING
chmod a-x examples/vnstat.cgi

%build
%configure
%make_build

%install
%makeinstall
/bin/install -pD %SOURCE1  %buildroot%_controldir/%name
/bin/install -pD %SOURCE3  %buildroot%_tmpfilesdir/%{name}d.conf

install -pD -m 0755 -- %SOURCE2 %buildroot/%_initdir/%{name}d
install -pD -m 0644 examples/systemd/vnstat.service %buildroot%_unitdir/%{name}d.service

mkdir -p %buildroot%piddir
mkdir -p %buildroot%data_dir


%pre
%_sbindir/groupadd -r -f %name &>/dev/null
%_sbindir/useradd -r -g %name -d %data_dir -s /dev/null \
	-c "vnStat database producer" -M -G proc -n %name &>/dev/null ||:

# For upgrade from 1.4-alt1 
/usr/bin/id -Gn %name | /bin/grep -qw proc || %_sbindir/usermod -G proc %name ||:


%post server
%post_service %{name}d

%postun server
[ $1 = 0 ] && echo 'NOTE: %name databases still exists in %data_dir directory!'
%preun_service %{name}d


%files
%doc CHANGES FAQ README
%doc --no-dereference COPYING

%config(noreplace) %_sysconfdir/%name.conf

%_bindir/%name
%_man1dir/%{name}.*
%_man5dir/%{name}.*

%attr(1770,root,%name) %data_dir

%files server
%_sbindir/%{name}d
%_man8dir/%{name}d*
%config   %_initdir/%{name}d
%_unitdir/%{name}d.service
%_tmpfilesdir/%{name}d.conf
%_controldir/%name

%ghost %attr(1775,root,%name) %dir %piddir

%files vnstati
%doc examples/vnstat.cgi
%_bindir/%{name}i
%_man1dir/%{name}i*

%changelog
