Name: vpnc
Version: 0.5.3
Release: alt7

Summary: Client for cisco vpn concentrator
Group: Networking/Remote access
License: GPL

Url: http://www.unix-ag.uni-kl.de/~massar/vpnc/

Source: %name-%version.tar
Patch: %name-%version-%release.patch
Patch2: 0001-vpnc-skip-parsing-responder-lifetime-payload.patch

Packager: Ilya Mashkin <oddity@altlinux.org>

BuildRequires: libgcrypt-devel libgnutls-devel perl-autodie
Requires: iproute2 vpnc-script

%add_findreq_skiplist %_sysconfdir/vpnc/vpnc-script

%description
vpnc is supposed to work with:

* Cisco VPN concentrator 3000 Series
* Cisco IOS routers
* Cisco PIX / ASA Zecurity Appliances
* Juniper / Junos / SRX / Netscreen

Supported Authentications: Pre-Shared-Key + XAUTH, Pre-Shared-Key
Supported IKE DH-Groups: dh1 dh2 dh5
Supported Hash Algo (IKE/IPSEC): md5 sha1
Supported Encryptions (IKE/IPSEC): (null) (1des) 3des aes128 aes192 aes256
Perfect Forward Secrecy: nopfs dh1 dh2 dh5

%package script
Summary: Routing setup script for vpnc and openconnect
Group: Networking/Remote access
BuildArch: noarch

%description script
This script sets up routing for VPN connectivity, when invoked by vpnc
or openconnect.

%prep
%setup -q
%patch -p1
%patch2 -p1

%build
CFLAGS="$RPM_OPT_FLAGS -fPIE" LDFLAGS="$RPM_OPT_FLAGS -pie" %make PREFIX=%_prefix

%install
%makeinstall_std PREFIX=%_prefix

mkdir -p %buildroot%_tmpfilesdir
install -m 0644 vpnc-tmpfiles.conf %buildroot%_tmpfilesdir/%name.conf

mkdir -p %buildroot%_runtimedir/%name
touch %buildroot%_runtimedir/%name/defaultroute \
      %buildroot%_runtimedir/%name/resolv.conf-backup

%files
%doc README TODO COPYING juniper.txt nortel.txt
%config(noreplace) %_sysconfdir/%name/default.conf
%_bindir/*
%_sbindir/*
%_man1dir/*
%_man8dir/*
%_tmpfilesdir/%name.conf
%dir %_runtimedir/%name
%ghost %verify(not md5 size mtime) %_runtimedir/%name/defaultroute
%ghost %verify(not md5 size mtime) %_runtimedir/%name/resolv.conf-backup

%files script
%dir %_sysconfdir/%name
%config(noreplace) %_sysconfdir/%name/vpnc-script

%changelog
