%define subname		avkys
%define major	9.2
%define libname lib%name

Name: webcamoid
Version: %major.3
Release: alt1

Summary: A webcam funny video tool

Group: Video
License: GPL-3.0-or-later
Url: https://github.com/hipersayanX/webcamoid

Packager: Alexei Mezin <alexvm@altlinux.ru>

# Source-url: https://github.com/webcamoid/webcamoid/archive/%version.tar.gz
Source: %name-%version.tar
Patch0: %{name}_manpath.patch

BuildRequires(pre): rpm-macros-cmake
BuildRequires(pre): rpm-macros-qt6
BuildRequires: cmake


BuildRequires: qt6-base-devel
BuildRequires: qt6-svg-devel
BuildRequires: qt6-charts-devel

BuildRequires: pkgconfig(gstreamer-pbutils-1.0)
BuildRequires: pkgconfig(gstreamer-app-1.0)
BuildRequires: pkgconfig(gstreamer-1.0)
BuildRequires: pkgconfig(libavdevice)
BuildRequires: pkgconfig(libavformat)
BuildRequires: pkgconfig(libavcodec)
BuildRequires: pkgconfig(libv4l2)
BuildRequires: pkgconfig(libffi)
BuildRequires: pkgconfig(libvlc)
BuildRequires: pkgconfig(libuvc)
BuildRequires: pkgconfig(libpulse-simple)
BuildRequires: pkgconfig(libkmod)
BuildRequires: pkgconfig(libpcre)
BuildRequires: pkgconfig(libswscale)
BuildRequires: pkgconfig(libswresample)
BuildRequires: pkgconfig(libavfilter)
BuildRequires: pkgconfig(libpostproc)
BuildRequires: pkgconfig(libswresample)
BuildRequires: pipewire-libs-devel libjack-devel liborc-devel pipewire-libs-devel libalsa-devel

Requires: %libname = %EVR

%description
Webcamoid is a full featured webcam capture application.
Features:
    * Take pictures and record videos with the webcam.
    * Manages multiple webcams.
    * Written in C++/Qt.
    * Custom controls for each webcam.
    * Add funny effects to the webcam.
    * +60 effects available.
    * Effects with live previews.
    * Translated to many languages.
    * Use custom network and local files as capture devices.
    * Capture from desktop.

%package -n %libname
Summary: The webcamoid library
Group: System/Libraries

%description -n %libname
This package contains the library for webcamoid.

%package -n %libname-devel
Summary: Headers for developing programs that will use avkys lib
Group: Development/C++
Requires: %libname = %EVR

%description -n %libname-devel
This package contains the headers that programmers will need to develop
applications which will use avkys library as webcamoid.

%prep
%setup
#patch0 -p1
sed -i -e 's|/qt/qml|/qt6/qml|' -e 's|/qt/plugins|/qt6/plugins|' CMakeLists.txt libAvKys/cmake/ProjectCommons.cmake

%build
%cmake
%cmake_build

%install
%cmake_install

%files
%doc AUTHORS TODO README.md
%_bindir/webcamoid
%_desktopdir/webcamoid.desktop
%_iconsdir/hicolor/*/apps/webcamoid.*
%_man1dir/webcamoid.1*
%_qt6_plugindir/avkys/
%_datadir/licenses/webcamoid/COPYING
%_datadir/metainfo/io.github.webcamoid.Webcamoid.metainfo.xml

%files -n %libname
%_libdir/lib%subname.so.*
# datadir/licenses/avkys/COPYING

%files -n %libname-devel
%_libdir/*.so

%changelog
