# Unpackaged files in buildroot should terminate build
%define _unpackaged_files_terminate_build 1

%def_with webkitgtk
%def_with sdl

%define wxbranch 3.2

Name: wxGTK3.2
Version: 3.2.8.1
Release: alt1

Summary: The GTK+ port of the wxWidgets library
License: wxWidgets
Group: System/Libraries
URL: https://wxwidgets.org
VCS: https://github.com/wxWidgets/wxWidgets.git

Source: %name-%version.tar
Source1: catch.tar
Source2: pcre.tar
Source3: nanosvg.tar
Source11: ld_shared_wrapper.pl
Patch1: wxGTK3.0-disable-ABI-checking.patch

BuildRequires: gcc-c++
BuildRequires: libGL-devel libGLU-devel libSM-devel
BuildRequires: libX11-devel libXinerama-devel libICE-devel libXmu-devel libXext-devel libXp-devel
BuildRequires: xorg-xextproto-devel xorg-inputproto-devel libXtst-devel
BuildRequires: libexpat-devel
BuildRequires: libjpeg-devel libtiff-devel libpng-devel libmspack-devel zlib-devel
BuildRequires: libgtk+3-devel libcairo-devel
BuildRequires: libxkbcommon-devel

BuildRequires: libXxf86vm-devel libbfd-devel
BuildRequires: libstdc++-devel
#BuildRequires: libGConf-devel
BuildRequires: gstreamer1.0-devel gst-plugins1.0-devel
BuildRequires: libnotify-devel
BuildRequires: libcurl-devel

%if_with webkitgtk
BuildRequires: libwebkit2gtk-devel
%endif

%if_with sdl
BuildRequires: libSDL2-devel
%endif

%description
wxWidgets is a free C++ library for cross-platform GUI development.
With wxWidgets, you can create applications for different GUIs
(GTK+, Motif/LessTif, MS Windows, Mac) from the same source code.

This is a GTK+ port.

%package -n libwxBase%wxbranch
Summary: Non-GUI support classes from the wxWidgets library
Group: System/Libraries
Conflicts: lib%name < %EVR

%description -n libwxBase%wxbranch
Every wxWidgets application must link against this library. It contains
mandatory classes that any wxWidgets code depends on (like wxString) and
portability classes that abstract differences between platforms. wxBase can
be used to develop console mode applications -- it does not require any GUI
libraries or the X Window System.

%package -n libwxBase%wxbranch-devel
Group: Development/C++
Summary: Development files for the wxBase3 library
Requires: libwxBase%wxbranch = %EVR
Conflicts: lib%name-devel < %EVR
Conflicts: libwxGTK2.9-devel
Conflicts: libwxGTK3.0-devel
Conflicts: libwxGTK3.1-devel
Conflicts: libwxBase3.0-devel
Conflicts: libwxBase3.1-devel
Conflicts: wxGTK-devel
Conflicts: libwxGTK-devel

%description -n libwxBase%wxbranch-devel
This package include files needed to link with the wxBase3 library.
wxWidgets is the GTK port of the C++ cross-platform wxWidgets
GUI library, offering classes for all common GUI controls as well as a
comprehensive set of helper classes for most common application tasks,
ranging from networking to HTML display and image manipulation.

%package -n lib%name
Summary: The GTK+ port of the wxWidgets library
Group: System/Libraries
Requires: libwxBase%wxbranch = %EVR

%description -n lib%name
Header files for wxGTK, the GTK+ port of the wxWidgets library.

%package -n lib%name-gl
Summary: OpenGL add-on for the wxWidgets library
Group: System/Libraries
Requires: lib%name = %EVR
Conflicts: lib%name < %EVR

%description -n lib%name-gl
OpenGL (a 3D graphics API) add-on for the wxWidgets library.
wxWidgets is the GTK port of the C++ cross-platform wxWidgets
GUI library, offering classes for all common GUI controls as well as a
comprehensive set of helper classes for most common application tasks,
ranging from networking to HTML display and image manipulation.

%package -n lib%name-webview
Summary: WebView add-on for the wxWidgets library
Group: System/Libraries
Requires: lib%name = %EVR

%description -n lib%name-webview
WebView add-on for the wxWidgets library.
wxWidgets is the GTK port of the C++ cross-platform wxWidgets
GUI library, offering classes for all common GUI controls as well as a
comprehensive set of helper classes for most common application tasks,
ranging from networking to HTML display and image manipulation.

%package -n lib%name-sound_sdlu
Summary: sound_sdlu add-on for the wxWidgets library
Group: System/Libraries
Requires: libwxBase%wxbranch = %EVR

%description -n lib%name-sound_sdlu
sound_sdlu add-on for the wxWidgets library.
wxWidgets is the GTK port of the C++ cross-platform wxWidgets
GUI library, offering classes for all common GUI controls as well as a
comprehensive set of helper classes for most common application tasks,
ranging from networking to HTML display and image manipulation.

%package -n lib%name-media
Summary: Multimedia add-on for the wxWidgets library
Group: System/Libraries
Requires: lib%name = %EVR
Conflicts: lib%name < %EVR

%description -n lib%name-media
Multimedia add-on for the wxWidgets library.
wxWidgets is the GTK port of the C++ cross-platform wxWidgets
GUI library, offering classes for all common GUI controls as well as a
comprehensive set of helper classes for most common application tasks,
ranging from networking to HTML display and image manipulation.

%package -n lib%name-devel
Summary: Development files for wxGTK library
Group: Development/C++
Requires: lib%name = %EVR
Requires: lib%name-gl = %EVR
Requires: lib%name-media = %EVR
Requires: libwxBase%wxbranch-devel = %EVR
%if_with webkitgtk
Requires: lib%name-webview = %EVR
%endif
%if_with sdl
Requires: lib%name-sound_sdlu = %EVR
%endif
%add_python_req_skip utils

%description -n lib%name-devel
Header files for wxGTK, the GTK+ port of the wxWidgets library.

%package i18n
Summary: i18n message catalogs for the wxWidgets library
Group: Development/C++
BuildArch: noarch

%description i18n
i18n message catalogs for the wxWidgets library.
wxWidgets is the GTK port of the C++ cross-platform wxWidgets
GUI library, offering classes for all common GUI controls as well as a
comprehensive set of helper classes for most common application tasks,
ranging from networking to HTML display and image manipulation.

%package examples
Summary: wxGTK example programs
Group: Development/C++
BuildArch: noarch
Requires: lib%name-devel = %EVR

%description examples
wxGTK example programs.

%prep
%setup
tar -xf %SOURCE1 -C 3rdparty/
tar -xf %SOURCE2 -C 3rdparty/
tar -xf %SOURCE3 -C 3rdparty/

%autopatch -p1

# patch some installed files to avoid conflicts with 2.8.*
sed -i -e 's|bakefile/presets|bakefile/presets-\$(WX_RELEASE)|g' Makefile.in

rm -fR src/{expat,jpeg,tiff,zlib,png}

%build
CONF_FLAG=" \
	--enable-option-checking\
	--enable-shared \
	--with-zlib=sys \
	--with-expat=sys \
	--enable-display \
	--with-libjpeg=sys \
	--with-libpng=sys \
	--with-libtiff=sys \
	--with-opengl \
%if_with sdl
	--with-sdl \
%endif
	--enable-unicode \
	--enable-optimise \
	--with-regex=yes \
	--disable-rpath \
	--disable-joystick \
	--enable-webrequest \
	--enable-plugins \
	--enable-precomp-headers=yes \
	--enable-mediactrl \
	--enable-sound \
	--enable-stc \
	--enable-gui \
	--enable-graphics_ctx \
	--with-libmspack \
	--disable-stl \
	--enable-ipv6 \
	--with-subdirs"

./autogen.sh
export LIBS="-lX11"
DEFS="-DUNICODE=1 -DwxUSE_UNICODE=1"
%add_optflags -fno-strict-aliasing -std=gnu++11 $GST_CFLAGS $DEFS

%configure $CONF_FLAG \
	--with-gtk=3 \
%if_with webkitgtk
	--enable-webview
%endif
	%nil
%make_build

%make -C locale allmo

%install
%makeinstall_std

mkdir -p %buildroot%_datadir/wx-%wxbranch/examples/src
cp -a demos samples %buildroot%_datadir/wx-%wxbranch/examples

cp -fR include/wx/private %buildroot%_includedir/wx-%wxbranch/wx/
cp -fR include/wx/unix/private %buildroot%_includedir/wx-%wxbranch/wx/unix/

%find_lang wxstd-3.2 wxmsw32 --output=wxstd.lang

# https://bugzilla.altlinux.org/47593
ln -s %_bindir/wx-config %buildroot%_bindir/wx-config-%wxbranch

%files -n libwxBase%wxbranch
%_libdir/libwx_baseu-*.so.*
%_libdir/libwx_baseu_net-*.so.*
%_libdir/libwx_baseu_xml-*.so.*
%dir %_libdir/wx

%files -n libwxBase%wxbranch-devel
%_bindir/wx-config
%_bindir/wxrc
%_bindir/wxrc-%wxbranch
%_bindir/wx-config-%wxbranch
%_includedir/wx-%wxbranch
%_libdir/libwx_baseu*.so
%dir %_libdir/wx
%dir %_libdir/wx/config
%dir %_libdir/wx/include
%_datadir/aclocal/wxwin.m4
%_datadir/bakefile/presets-%wxbranch
#_libexecdir/%name

%if_with sdl
%files -n lib%name-sound_sdlu
%dir %_libdir/wx/%wxbranch
%_libdir/wx/%wxbranch/sound_sdlu-*.so
%endif

%if_with webkitgtk
%files -n lib%name-webview
%dir %_libdir/wx/%wxbranch
%_libdir/libwx_gtk3u_webview-*.so.*
%_libdir/wx/%wxbranch/web-extensions
%endif

%files -n lib%name
%doc docs/changes.txt docs/gpl.txt docs/lgpl.txt docs/licence.txt
%doc docs/licendoc.txt docs/preamble.txt docs/readme.txt
%_libdir/libwx_gtk3u_adv-*.so.*
%_libdir/libwx_gtk3u_aui-*.so.*
%_libdir/libwx_gtk3u_core-*.so.*
%_libdir/libwx_gtk3u_html-*.so.*
%_libdir/libwx_gtk3u_propgrid-*.so.*
%_libdir/libwx_gtk3u_qa-*.so.*
%_libdir/libwx_gtk3u_ribbon-*.so.*
%_libdir/libwx_gtk3u_richtext-*.so.*
%_libdir/libwx_gtk3u_stc-*.so.*
%_libdir/libwx_gtk3u_xrc-*.so.*
%if_with webkitgtk
%exclude %_libdir/libwx_gtk3u_webview-*.so.*
%endif

%files -n lib%name-gl
%_libdir/libwx_gtk3u_gl-*.so.*

%files -n lib%name-media
%_libdir/libwx_gtk3u_media-*.so.*

%files -n lib%name-devel
%_libdir/libwx_gtk3u_*.so
%_libdir/wx/config/gtk3-unicode-%wxbranch
%_libdir/wx/include/gtk3-unicode-%wxbranch

%files i18n -f wxstd.lang

%files examples
%_datadir/wx-%wxbranch/examples

%changelog
