# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}

Name: xaos
Epoch: 1
Version: 4.2.1
Release: alt1
Summary: A real-time fractal zoomer
License: GPLv3+
Group: Sciences/Mathematics
Packager: Igor Vlasenko <viy@altlinux.org>
URL: https://xaos-project.github.io
VCS: https://github.com/xaos-project/XaoS
Source0: %{name}-%{version}.tar

Source10: %name.16.xpm
Source11: xaos.png
Source12: %name.48.xpm

Provides : XaoS = %version, %name-aalib = %version
Obsoletes: XaoS, %name-aalib

BuildRequires(pre): rpm-macros-qt5
BuildRequires: gcc-c++
BuildRequires: qt5-base-devel >= 5.7
BuildRequires: qt5-designer qt5-tools

%description
XaoS is a fast portable real-time interactive fractal zoomer. It
displays the Mandelbrot set (among other escape time fractals) and
allows you to zoom smoothly into the fractal.  Various coloring modes
are provided for both the points inside and outside the selected set.
In addition, switching between Julia and Mandelbrot fractal types and
displaying planes is provided.

%prep
%setup -q

%build
%qmake_qt5
%make_build STRIP=:

%install
# Empty install target generated by qmake => install files manually
# Binary
install -D -m 0755 --target-directory %buildroot%_bindir bin/%name

# Data; Datapath forced to %%{alt_name} (not configurable)
install -D --mode 0644 --target-directory %buildroot%_datadir/XaoS/catalogs catalogs/*.cat
cp --archive examples tutorial %buildroot%_datadir/XaoS

# icon
install -D -m 644 %SOURCE10 %buildroot%_miconsdir/%name.xpm
install -D -m 644 %SOURCE11 %buildroot%_niconsdir/%name.png
install -D -m 644 %SOURCE12 %buildroot%_liconsdir/%name.xpm
install -D -m 644 xdg/%name.png %buildroot%_iconsdir/hicolor/256x256/apps/%name.png

# .desktop, AppData
install -D --mode 0644 --target-directory %buildroot%_datadir/metainfo xdg/%name.appdata.xml
install -D --mode 0644 --target-directory %buildroot%_desktopdir xdg/%name.desktop

# Man
install -D --mode 0644 --target-directory %{buildroot}%{_mandir}/man6 doc/%{name}.6

%files
%doc CREDITS.md NEWS doc/README
#doc COPYING
%_bindir/%name
%_datadir/XaoS
%_mandir/man6/*
%_desktopdir/%name.desktop
%_datadir/metainfo/%name.appdata.xml
%_miconsdir/%name.xpm
%_niconsdir/%name.png
%_liconsdir/%name.xpm
%_iconsdir/hicolor/256x256/apps/%name.png

%changelog
