# Unpackaged files in buildroot should terminate build
%define _unpackaged_files_terminate_build 1

Name: xdg-user-dirs-gtk
Version: 0.14
Release: alt1
Summary: Gnome integration of special directories
Group: Graphical desktop/GNOME
License: GPL-2.0-or-later
URL: https://git.gnome.org/browse/xdg-user-dirs-gtk

Requires: xdg-user-dirs

Source: %name-%version.tar
Patch: %name-%version-%release.patch

BuildRequires(pre): rpm-macros-meson
BuildRequires: meson
BuildRequires: pkgconfig(gtk+-3.0)
BuildRequires: xdg-user-dirs

%description
Contains some integration of xdg-user-dirs with the gnome
desktop, including creating default bookmarks and detecting
locale changes.

%prep
%setup
%autopatch -p1

%build
%meson
%meson_build

%install
%meson_install

mv %buildroot%_sysconfdir/xdg/autostart/user-dirs-update-gtk.desktop \
   %buildroot%_sysconfdir/xdg/autostart/%name.desktop

rm -v %buildroot%_desktopdir/user-dirs-update-gtk.desktop

%find_lang %name

%files -f %name.lang
%doc NEWS AUTHORS README ChangeLog COPYING
%_sysconfdir/xdg/autostart/%name.desktop
%_bindir/xdg-user-dirs-gtk-update

%changelog
