%define xorg xorg-x11
%define xf86 XFree86

Name: xdm
Version: 1.1.13
Release: alt2
Epoch: 2
Summary: X Display Manager with support for XDMCP, host chooser
License: MIT/X11
Group: System/X11
Url: http://xorg.freedesktop.org

Source: %name-%version.tar.gz
Source1: %name.logrotate
Source2: %name.pamd
Source3: Xlogin

Patch0: xdm-1.1.12-inpColor.patch
Patch1: 0003-Fix-defaults-path.patch
Patch2: 0029-hackaround-for-23108.patch

Obsoletes: %xf86-%name %xorg-%name < %epoch:%version-%release
Provides: %xf86-%name = 4.4 %xorg-%name = %epoch:%version-%release

# Automatically added by buildreq on Thu Mar 28 2019
# optimized out: fontconfig-devel glibc-kernheaders-generic glibc-kernheaders-x86 libICE-devel libSM-devel libX11-devel libXau-devel libXmu-devel libXrender-devel libXt-devel libcrypt-devel libfreetype-devel perl pkg-config python-base sh4 xorg-proto-devel
BuildRequires: libXaw-devel libXdmcp-devel libXext-devel libXft-devel libXinerama-devel libXpm-devel libpam-devel
BuildRequires: xorg-util-macros libbsd-devel 

%description
Xdm  manages a collection of X displays, which may be on the local host
or remote servers.  The design of xdm was guided by the needs of X ter-
minals  as well as The Open Group standard XDMCP, the X Display Manager
Control Protocol.  Xdm provides services similar to those  provided  by
init,  getty and login on character terminals: prompting for login name
and password, authenticating the user, and running a ``session.''

%prep
%setup
%patch0 -p1
%patch1 -p1
%patch2 -p1

%build
%autoreconf
%configure \
	--with-xdmlibdir=%_libdir/X11/xdm \
	--with-xdmconfigdir=%_sysconfdir/X11/xdm \
	--with-xdmscriptdir=%_sysconfdir/X11/xdm \
	--with-pixmapdir=%_datadir/X11/xdm/pixmaps \
	--with-xft \
	--enable-xdm-auth \
	--enable-xdmshell \
	--disable-static

%make_build CFLAGS+="-Wno-discarded-qualifiers"

%install
%makeinstall_std

install -pD -m640 %SOURCE1 %buildroot%_sysconfdir/logrotate.d/xdm
install -pD -m644 %SOURCE2 %buildroot%_sysconfdir/pam.d/xdm
install -pD -m640 %SOURCE3 %buildroot%_x11appconfdir/Xlogin

# explicitly create X authdir
mkdir -p %buildroot%_localstatedir/xdm
ln -snf ../../..%_localstatedir/xdm %buildroot%_sysconfdir/X11/xdm/authdir

%files
%doc README* config/Xresources
%config(noreplace) %_sysconfdir/X11/app-defaults/*
%dir %_sysconfdir/X11/xdm/
%_sysconfdir/X11/xdm/authdir
%config(noreplace) %_sysconfdir/logrotate.d/xdm
%config(noreplace) %_sysconfdir/pam.d/xdm
%_bindir/*
%_libdir/X11/xdm
%_datadir/X11/xdm
%dir %attr(700,root,root) %_localstatedir/xdm/
%_man8dir/*

%changelog
