Name: xfce4-screensaver
Version: 4.20.1
Release: alt1

Summary: Screen saver and locker for Xfce
License: GPLv2+ and LGPLv2+
Group: Graphical desktop/XFce
Url: https://git.xfce.org/apps/xfce4-screensaver/about/

Vcs: https://gitlab.xfce.org/apps/xfce4-screensaver.git
Source: %name-%version.tar
Patch: %name-%version-%release.patch
Packager: Xfce Team <xfce@packages.altlinux.org>

# Wayland support disabled for now: this requires libwlembed
# (https://gitlab.xfce.org/kelnos/libwlembed) which is not released yet.
%def_disable wayland

BuildRequires(pre): meson rpm-macros-meson >= 1.3.1-alt1
BuildRequires(pre): rpm-build-xfce4 >= 0.3.0 xfce4-dev-tools >= 4.17.1
BuildRequires(pre): rpm-build-xdg
BuildRequires: libxfconf-devel libgarcon-gtk3-devel libxfce4ui-gtk3-devel >= 4.18.4 libxfce4util-devel
BuildRequires: glib2-devel libgtk+3-devel libgio-devel
BuildRequires: libdbus-glib-devel libdbus-devel
BuildRequires: libX11-devel libXext-devel
BuildRequires: libXScrnSaver-devel libxklavier-devel
BuildRequires: libwnck3-devel
BuildRequires: libsystemd-devel libpam0-devel libwnck3-devel
%{?_enable_wayland:Buildrequires: wayland-devel libwlembed-gtk3-devel libwayland-client-devel wayland-protocols libxfce4windowing-devel}
BuildRequires: xmlto
# For xfce4-screensaver-configure
BuildRequires: rpm-build-python3

Requires: xfce4-common

%define _unpackaged_files_terminate_build 1

%description
%name is a screen saver and locker that aims to have simple, sane,
secure defaults and be well integrated with the desktop.

This project is a port of MATE Screensaver, itself a port of GNOME Screensaver.
It has been tightly integrated with the Xfce desktop, utilizing Xfce libraries
and the Xfconf configuration backend.

%prep
%setup
%patch -p1

%build
%meson \
	-Dx11=enabled \
	%{subst_enable_meson_feature wayland wayland} \
	-Dauthentication-scheme=pam \
	-Dpam-auth-type=system \
	-Dsession-manager=systemd \
	-Ddocs=enabled

%meson_build -v

%install
%meson_install
%find_lang %name

%files -f %name.lang
%doc AUTHORS NEWS README.md
%attr(640,root,chkpwd) %config(noreplace) %_sysconfdir/pam.d/%name
%_xdgconfigdir/autostart/%name.desktop
%_xdgmenusdir/*.menu
%_bindir/%{name}*
%_libexecdir/%{name}*
%attr(2711,root,chkpwd) %_libexecdir/%name-dialog
%_desktopdir/screensavers/*.desktop
%_desktopdir/*.desktop
%_datadir/dbus-1/services/*.service
%_datadir/desktop-directories/*.directory
%_iconsdir/hicolor/*/apps/*
%_man1dir/*
%_pixmapsdir/*.svg

%changelog
