Name: xfce4-settings
Version: 4.20.2
Release: alt1
Summary: Settings Manager for Xfce
Summary (ru_RU.UTF-8): Менеджер настроек Xfce

License: GPLv2+
Url: https://docs.xfce.org/xfce/xfce4-settings/start
Group: Graphical desktop/XFce
Packager: Xfce Team <xfce@packages.altlinux.org>

Vcs: https://gitlab.xfce.org/xfce/xfce4-settings.git
Source: %name-%version.tar
Source1: xfce4-fixkeyboard
Patch: %name-%version-%release.patch

%def_enable upower

BuildPreReq: rpm-build-xfce4 xfce4-dev-tools > 4.5
BuildRequires: libxfce4ui-gtk3-devel libexo-gtk3-devel libxfconf-devel >= 4.19.3 libgarcon-devel >= 4.18.0
BuildRequires: libX11-devel libXcursor-devel libXi-devel libXrandr-devel libnotify-devel libxklavier-devel
Buildrequires: libXext-devel
BuildRequires: libwayland-client-devel wayland-devel >= 1.20 wlr-protocols libgtk-layer-shell-devel
%{?_enable_upower:BuildRequires: libupower-devel >= 0.99.10}
BuildRequires: libcolord-devel
BuildRequires: xorg-drv-libinput-devel
BuildRequires: xml-utils
# For xfce4-compose-mail script
BuildRequires: rpm-build-python3

Requires: libgarcon-settings-manager-menu
Requires: xfce4-common

Obsoletes: xfce4-mcs-manager xfce4-mcs-plugins

Conflicts: libexo-common < 4.15.2-alt1

%define _unpackaged_files_terminate_build 1

%description
This package provides the settings manager applications
for the Xfce desktop.

%description -l ru_RU.UTF-8
Данный пакет содержит в себе менеджер настроек для окружения рабочего
стола Xfce.

%prep
%setup
%patch -p1
%xfce4_cleanup_version

%build
%xfce4reconf
%configure  \
	--enable-debug=minimum \
	--disable-silent-rules \
	--enable-x11 \
	--enable-wayland \
	--enable-libnotify \
%if_enabled upower
	--enable-upower-glib \
%else
	--disable-upower-glib \
%endif
	--enable-xcursor \
	--enable-xorg-libinput \
	--enable-libxklavier \
	--enable-sound-settings \
	--enable-colord
%make

%install
%makeinstall_std
%find_lang %name
install -pDm0755 %SOURCE1 %buildroot%_bindir/xfce4-fixkeyboard

%files -f %name.lang
%doc README.md NEWS COPYING AUTHORS
%_bindir/*
%_libdir/xfce4/*
%_libdir/gtk-3.0/modules/*.so
%config(noreplace) %_sysconfdir/xdg/autostart/*
%config(noreplace) %_sysconfdir/xdg/xfce4/xfconf/xfce-perchannel-xml/xsettings.xml
%_sysconfdir/xdg/menus/xfce-settings-manager.menu
%config(noreplace) %_sysconfdir/xdg/xfce4/helpers.rc
%exclude %_datadir/xfce4/helpers/debian-*.desktop
%_datadir/xfce4/*
%_desktopdir/*.desktop
%_iconsdir/*/*/*/*.*

%exclude %_libdir/gtk-3.0/modules/*.la

%changelog
