Name: xfce4-verve-plugin
Version: 2.1.0
Release: alt1

Summary: Command line plugin for Xfce Desktop
License: GPLv2+
Group: Graphical desktop/XFce
Url: https://docs.xfce.org/panel-plugins/xfce4-verve-plugin
Packager: Xfce Team <xfce@packages.altlinux.org>

Vcs: https://gitlab.xfce.org/panel-plugins/xfce4-verve-plugin.git
Source: %name-%version.tar
Patch: %name-%version-%release.patch

Obsoletes: verve-plugin < 0.3.6
Provides: verve-plugin

BuildRequires(pre): meson rpm-macros-meson >= 1.3.1-alt1
BuildRequires: rpm-build-xfce4 xfce4-dev-tools
BuildRequires: libxfce4util-devel libxfce4panel-gtk3-devel >= 4.16.0 libxfce4ui-gtk3-devel
BuildRequires: libpcre2-devel

Requires: xfce4-panel
Requires: exo-utils

%define _unpackaged_files_terminate_build 1

%description
The Verve panel plugin is a comfortable command line (or smartbookmark)
plugin for the Xfce panel. It supports several nice features, such as:
    * Command history
    * Auto-completion (including command history)
    * Open URLs and e-mail addresses in your favourite applications
    * Expansion of variables in directory names with wordexp,
      and variable and alias support in commands by running them
      through current shell
    * Optional support for sending ! and \ queries to DuckDuckGo
    * Focus grabbing via D-BUS (so you can bind a shortcut to it)
    * Custom input field width

%prep
%setup
#patch -p1

%build
%meson
%meson_build -v

%install
%meson_install
%find_lang %name

%files -f %name.lang
%doc README.md AUTHORS
%_libdir/xfce4/panel/plugins/*.so
%_datadir/xfce4/panel/plugins/*.desktop

%changelog
