Name: xfce4-whiskermenu-plugin
Version: 2.10.0
Release: alt1

Summary: Alternate Xfce menu
License: GPLv2+
Group: Graphical desktop/XFce
Url: https://docs.xfce.org/panel-plugins/xfce4-whiskermenu-plugin
Packager: Xfce Team <xfce@packages.altlinux.org>

Vcs: https://gitlab.xfce.org/panel-plugins/xfce4-whiskermenu-plugin.git
Source: %name-%version.tar
Patch: %name-%version-%release.patch

%if_xfce4_wayland_support
%def_enable wayland
%else
%def_disable wayland
%endif

BuildRequires(pre): meson rpm-macros-meson >= 1.3.1-alt1
BuildRequires(pre): rpm-build-xfce4 >= 0.3.0 xfce4-dev-tools
BuildRequires: gcc-c++
BuildRequires: libxfce4panel-gtk3-devel >= 4.16.0 libxfce4ui-gtk3-devel libxfce4util-devel
BuildRequires: libgarcon-devel libexo-gtk3-devel
BuildRequires: libaccountsservice-devel
%{?_enable_wayland:Buildrequires: libgtk-layer-shell-devel}

Requires: xfce4-panel

%define _unpackaged_files_terminate_build 1

%description
Whisker Menu is an alternate application launcher for Xfce. When you
open it you are shown a list of applications you have marked as
favorites. You can browse through all of your installed applications by
clicking on the category buttons on the side. Top level catagories make
browsing fast, and simple to switch between. Additionally, Whisker Menu
keeps a list of the last ten applications that you've launched from it.

%prep
%setup
%patch -p1

%build
%meson \
	-Daccountsservice=enabled \
	%{subst_enable_meson_feature wayland gtk-layer-shell}


%meson_build -v

%install
%meson_install
%find_lang %name

%files -f %name.lang
%_bindir/*
%_libdir/xfce4/panel/plugins/*.so
%_datadir/xfce4/panel/plugins/*.desktop
%_iconsdir/hicolor/*/apps/*
%_man1dir/*.1.*

%changelog
