%define libname libxmlrpc
# libxml2 backend is broken
%def_disable libxml2

Name: xmlrpc-c
Version: 1.54.06
Release: alt2

Summary: XML-RPC C library - an implementation of the xmlrpc protocol
License: BSD-3-Clause AND MIT
Group: System/Libraries

Url: http://xmlrpc-c.sourceforge.net/

Source: %name-%version.tar


Patch1: %name-1.12.00-alt-configure-fixes.patch
Patch2: 0001-cleanup-and-fix-libxml2-backend.patch

# Patches from fedora
Patch101: 0001-xmlrpc_server_abyss-use-va_args-properly.patch
Patch102: 0002-Use-proper-datatypes-for-long-long.patch
Patch103: 0003-allow-30x-redirections.patch

# Patches from OpenNebula
Patch201: xml_parse_huge.patch

BuildRequires: gcc-c++
BuildRequires: libcurl-devel
%{?_enable_libxml2:BuildRequires: libxml2-devel}
BuildRequires: libncurses-devel libreadline-devel
BuildRequires: libssl-devel zlib-devel

%description
XML-RPC for C/C++ is programming libraries and related tools to help you
write an XML-RPC server or client in C or C++.

%package -n %libname
Summary: XML-RPC C library - an implementation of the xmlrpc protocol
Group: System/Libraries

%description -n %libname
XML-RPC for C/C++ is programming libraries and related tools to help you
write an XML-RPC server or client in C or C++.

%package -n %libname-client
Summary: C client libraries for xmlrpc-c
Group: System/Libraries
Requires: %libname = %version-%release

%description -n %libname-client
XML-RPC is a quick-and-easy way to make procedure calls over the
Internet. It converts the procedure call into XML document, sends it
to a remote server using HTTP, and gets back the response as XML.

This library provides a modular implementation of XML-RPC for C
clients.

%package -n %libname-devel
Summary: Files for developing applications that use %libname
Requires: %libname = %version-%release
Requires: %libname++ = %version-%release
Requires: %libname-client = %version-%release
Requires: %libname-client++ = %version-%release
Group: Development/C

%description -n %libname-devel
The header file for developing applications that use
%name.

%package -n %libname++
Summary: XML-RPC C++ library - an implementation of the xmlrpc protocol
Group: System/Libraries
Requires: %libname = %version-%release

%description -n %libname++
XML-RPC for C/C++ is programming libraries and related tools to help you
write an XML-RPC server or client in C or C++.

This package contains C++ bindings for %libname.

%package -n %libname-client++
Summary: C++ client libraries for xmlrpc-c
Group: System/Libraries
Requires: %libname-client = %version-%release
Requires: %libname++ = %version-%release

%description -n %libname-client++
XML-RPC is a quick-and-easy way to make procedure calls over the
Internet. It converts the procedure call into XML document, sends it
to a remote server using HTTP, and gets back the response as XML.

This library provides a modular implementation of XML-RPC for C++
clients.

%package -n %libname++-devel
Summary: Files for developing applications that use %libname++
Requires: %libname++ = %version-%release
Requires: %libname-devel = %version-%release
Group: Development/C++

%description -n %libname++-devel
The header file for developing applications that use
%libname++.


%prep
%setup
%patch1 -p1
%if_enabled libxml2
%patch2 -p1
%endif
%patch101 -p1
%patch102 -p1
%patch103 -p1
%patch201 -p1

%build
autoconf
%configure \
	--disable-wininet-client \
	%{?_enable_libxml2:--enable-libxml2-backend}

%make
%make -C tools

%install
%makeinstall_std
%makeinstall_std -C tools
rm -f %buildroot%_libdir/*.a

%files
%doc README doc/*
%doc tools/xmlrpc_transport/xmlrpc_transport.html
%_man1dir/*
%_bindir/*
%exclude %_bindir/xmlrpc-c-config

%files -n %libname
%_libdir/libxmlrpc.so.*
%_libdir/libxmlrpc_*.so.*
%exclude %_libdir/libxmlrpc_cpp.so.*
%exclude %_libdir/libxmlrpc_*++.so.*
%exclude %_libdir/libxmlrpc_client.so.*

%files -n %libname-client
%_libdir/libxmlrpc_client.so.*

%files -n %libname++
%_libdir/libxmlrpc_cpp.so.*
%_libdir/libxmlrpc++.so.*
%_libdir/libxmlrpc_*++.so.*
%exclude %_libdir/libxmlrpc_client++.so.*

%files -n %libname-client++
%_libdir/libxmlrpc_client++.so.*

%files -n %libname-devel
%_bindir/xmlrpc-c-config
%_includedir/xmlrpc-c/
%_includedir/*.h
%_pkgconfigdir/*.pc
%_libdir/*.so

%changelog
