%def_with gtest

Name: xournalpp
Version: 1.2.1
Release: alt1
Summary: Handwriting note-taking software with PDF annotation support
Group: Office

License: GPLv2+
Url: https://github.com/%name/%name
Source: %name-%version.tar.gz
Patch: xournalpp-gcc13.patch
Patch1: xournalpp-x32.patch
Requires: %name-plugins = %version-%release
Requires: %name-ui = %version-%release
%add_findreq_skiplist %_datadir/%name/plugins/Example/*

BuildRequires(pre): cmake

# Automatically added by buildreq on Thu Sep 28 2023
# optimized out: at-spi2-atk cmake-modules fontconfig-devel glib2-devel glibc-kernheaders-generic glibc-kernheaders-x86 libX11-devel libXau-devel libXext-devel libXfixes-devel libXft-devel libXrender-devel libalsa-devel libat-spi2-core libatk-devel libcairo-devel libcairo-gobject libcairo-gobject-devel libfreetype-devel libgdk-pixbuf libgdk-pixbuf-devel libgio-devel libgpg-error libharfbuzz-devel libp11-kit libpango-devel libpoppler8-glib libsasl2-3 libstdc++-devel libwayland-client libwayland-cursor libwayland-egl libxcb-devel lua5.4 perl perl-Encode perl-Locale-gettext perl-parent pipewire-jack-libs pipewire-libs pkg-config python3 python3-base sh4 xorg-proto-devel zlib-devel
BuildRequires: cmake gcc-c++ git-core help2man libXi-devel libgtk+3-devel libpoppler-glib-devel libportaudio2-devel librsvg-devel libsndfile-devel libssl-devel libxml2-devel libzip-devel lsb-release lua-devel

%if_with gtest
BuildRequires: libgtest-devel ctest
%endif

%description
Xournal++ is a handwriting note-taking software with PDF annotation support.
Supports Pen input like Wacom Tablets

%package plugins
Summary: Default plugin for %name
BuildArch: noarch
Group: Office

%description plugins
The %name-plugins package contains sample plugins for  %name.

%package ui
Summary: User interface for %name
BuildArch: noarch
Group: Office

%description ui
The %name-ui package contains a graphical user interface for  %name.

%prep
%setup
%patch -p1
%patch1 -p1
%if "%EVR" == "1.2.1-alt1"
# XXX
sed -i '/EXPECT_TRUE(coordEq(a->getElementHeight()/d' test/unit_tests/control/LoadHandlerTest.cpp
%endif

%build
%if_with gtest
%cmake -DENABLE_GTEST=ON
%else
%cmake
%endif

%cmake_build

%if_with gtest
%cmake_build --target test-units
%endif

%install
%cmake_install

%find_lang %name

%check
%cmake_build --target test

%files -f %name.lang
%doc README.md AUTHORS
%_bindir/*
%_datadir/applications/com.github.%name.%name.desktop
%_datadir/icons/hicolor/scalable/apps/com.github.%name.%name.svg
%_datadir/icons/hicolor/scalable/mimetypes/*
%_datadir/mime/packages/com.github.%name.%name.xml
%_datadir/thumbnailers/com.github.%name.%name.thumbnailer
%_datadir/%name
%_datadir/metainfo/com.github.%name.%name.appdata.xml
%exclude %_datadir/%name/plugins
%exclude %_datadir/%name/ui
%_man1dir/*

%files plugins
%_datadir/%name/plugins

%files ui
%_datadir/%name/ui

%changelog
