Name: xroar
Version: 1.5.2
Release: alt1
Summary: Dragon and Tandy CoCo Emulator
License: GPL-3.0+
Group: Emulators
Url: https://www.6809.org.uk/xroar/
Packager: Artyom Bystrov <arbars@altlinux.org>

Source: https://www.6809.org.uk/xroar/dl/%name-%version.tar.gz
BuildRequires: ImageMagick-tools
BuildRequires: pkg-config
BuildRequires: libalsa-devel
BuildRequires: libgtk+2-devel
BuildRequires: libgtkglext-devel
BuildRequires: libpulseaudio-devel
BuildRequires: libSDL2-devel
BuildRequires: libsndfile-devel
BuildRequires: zlib-devel
BuildRequires: texinfo

%description
A Dragon 32, Dragon 64 and Tandy CoCo emulator for Unix, Linux, GP32, MacOS X
and Windows32. It uses standard cassette images (".cas" files) and virtual
diskettes (".dsk" or ".vdk" files) but has its own snapshot format at the
moment (no ".pak" file support).
.
Firmware ROM images are required to usefully run this emulator.
If you have difficulty extracting these from your real Dragon,
CoCo or MC-10, dumps may be available from the Dragon Archive (http://archive.worldofdragon.org/index.php?title=Main_Page)
or the Color Computer Archive (https://colorcomputerarchive.com).

%prep
%setup

%build
%configure --without-oss
%make_build

# Build docs
make html
make pdf

%install
mkdir -p %buildroot%_bindir
install -m 755 src/%name %buildroot%_bindir

# default rom directory
mkdir -p %buildroot%_datadir/%name/roms

# Generate desktop file
mkdir -p %buildroot%_desktopdir
cat >%buildroot%_desktopdir/%name.desktop <<EOF
[Desktop Entry]
Name=XRoar
GenericName=Dragon 32/64 Emulator
Comment=Emulates the Dragon 32/64 and Tandy CoCo
Exec=%name
Icon=%name
Terminal=false
Type=Application
Categories=Games;Emulator;
EOF

# install menu icons
for N in 16 32 48 64 128;
do
convert src/windows32/xroar-256x256.ico -scale ${N}x${N} $N.png;
install -D -m 0644 $N.png %buildroot%_iconsdir/hicolor/${N}x${N}/apps/%name.png
done


%files
%_bindir/%name
%_datadir/%name
%_iconsdir/hicolor/*/apps/%name.png
%_desktopdir/%name.desktop
%doc COPYING.GPL COPYING.LGPL
%doc ChangeLog README README.SDS
%doc doc/%name.html doc/%name-screens.png doc/%name-timebandit-af.png
%doc doc/%name.pdf

%changelog
