%define _unpackaged_files_terminate_build 1

Name: yasr
Version: 0.6.9
Release: alt2

Summary: %name - yet another screen reader
License: GPL-2.0-only
Group: Accessibility
Url: https://sourceforge.net/projects/yasr/
VCS: https://git.code.sf.net/p/yasr/git

Source: %name-%version.tar

BuildRequires(pre): rpm-build
BuildRequires: libtool
BuildRequires: gettext
BuildRequires: automake
BuildRequires: make
BuildRequires: gcc-c++

%description
YASR ("Yet Another Screen Reader") is the attempt at a lightweight,
portable screen reader. It works by opening a shell in a pty and
intercepting all user input/output, maintaining a window of what
should be on the screen by looking at the codes and text sent to the
screen. It thus uses no Linuxisms such as /dev/vcsa0 and does not 
necessarily need to be setuid root (the only requirement being that 
the user be able to access the tts device).

%prep
%setup

%build
%autoreconf
%configure
%make

%install
%makeinstall_std

# compatibility with ald package version
install -D -m 0664 %buildroot%_datadir/%name/%name.conf %buildroot%_sysconfdir/%name.conf
rm -v %buildroot%_datadir/%name/%name.conf
ln -s %_sysconfdir/%name.conf %buildroot%_datadir/%name/%name.conf

# remove locales
rm -rv %buildroot%_datadir/locale

%files
%config(noreplace) %_sysconfdir/%name.conf
%_bindir/%name
%_datadir/%name/%name.conf
%_man1dir/%name.1.xz
%doc ChangeLog BUGS CREDITS NEWS README TODO

%changelog
