%define ver_major 49
%define beta .beta
%def_enable check

Name: yelp-xsl
Version: %ver_major
Release: alt0.5%beta

Summary: XSLT stylesheets for the Yelp, GNOME help browser
License: GPL-2.0 and LGPL-2.1 and MIT
Group: Graphical desktop/GNOME
Url: http://yelp.io

Vcs: https://gitlab.gnome.org/GNOME/yelp-xsl.git

Source: https://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version%beta.tar.xz

BuildArch: noarch

BuildRequires(pre): rpm-macros-meson
BuildRequires: meson
BuildRequires: libxml2-devel libxslt-devel itstool xsltproc xmllint
BuildRequires: python3-module-mallard-ducktype

%description
Yelp is a help browser for the GNOME desktop. Yelp provides a simple
graphical interface for viewing DocBook, HTML, man, and info formatted
documentation.

This package contains XSLT stylesheets that are used by the Yelp.

%prep
%setup -n %name-%version%beta

%build
%meson
%meson_build

%install
%meson_install
%find_lang %name

%check
%__meson_test

%files -f %name.lang
%_datadir/%name
%_datadir/pkgconfig/yelp-xsl.pc
%doc AUTHORS README* NEWS COPYING

%changelog
