%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%define _libexecdir %_prefix/libexec
%define app_id dev.zed.Zed

%define webrtc_basedir %_builddir
%define webrtc_tar webrtc-b99fd2c-6
%ifarch x86_64
%define webrtc_source %SOURCE4
%define webrtc_dir %webrtc_basedir/linux-x64-release
%else
%define webrtc_source %SOURCE5
%define webrtc_dir %webrtc_basedir/linux-arm64-release
%endif

Name: zed
Version: 0.183.10
Release: alt1

Summary: A high-performance, multiplayer code editor from the creators of Atom and Tree-sitter
License: GPL-3.0 and AGPL-3.0 and Apache-2.0
Group: Editors
Url: https://zed.dev/
Vcs: https://github.com/zed-industries/zed

ExclusiveArch: x86_64 aarch64

Source0: %name-%version.tar
Source1: %name-%version-vendor.tar
Source2: config.toml
Source3: update-metadata-releases.py
Source4: https://github.com/livekit/client-sdk-rust/releases/download/%webrtc_tar/webrtc-linux-x64-release.zip
Source5: https://github.com/livekit/client-sdk-rust/releases/download/%webrtc_tar/webrtc-linux-arm64-release.zip
Patch0: %name-%version-alt.patch

# zed needs netcat to do `git fetch'
# see https://bugzilla.altlinux.org/53668
Requires: netcat

BuildRequires: /proc
BuildRequires: rust-cargo
BuildRequires: cargo-about
BuildRequires: cmake
BuildRequires: gcc-c++
BuildRequires: libssl-devel
BuildRequires: libzstd-devel
BuildRequires: libalsa-devel
BuildRequires: libxcb-devel
BuildRequires: libxkbcommon-devel
BuildRequires: libxkbcommon-x11-devel
BuildRequires: libX11-devel
BuildRequires: python3
BuildRequires: unzip

%description
Code at the speed of thought - Zed is a high-performance, multiplayer code
editor from the creators of Atom and Tree-sitter.

%prep
%setup -a1
%autopatch -p1
install -vpD %SOURCE2 .cargo/config.toml
install -vp  %SOURCE3 ./update-metadata-releases.py

unzip %webrtc_source -d %webrtc_basedir

%build
export RELEASE_VERSION="%version"
export ZED_UPDATE_EXPLANATION="Please update zed using apt-get."

# Upstream says that licenses should be generated before
# building the binaries. See the following for more info:
# https://github.com/zed-industries/zed/issues/14302
export ALLOW_MISSING_LICENSES=1
./script/generate-licenses

export LK_CUSTOM_WEBRTC="%webrtc_dir"
cargo build %_smp_mflags --release --offline --package zed --package cli

%install
install -pD -m0755 target/release/zed %buildroot%_libexecdir/zed-editor
install -pD -m0755 target/release/cli %buildroot%_bindir/zed
install -pD -m0644 crates/zed/resources/app-icon.png %buildroot%_iconsdir/hicolor/512x512/apps/%app_id.png
install -pD -m0644 crates/zed/resources/app-icon@2x.png %buildroot%_iconsdir/hicolor/1024x1024/apps/%app_id.png

export DO_STARTUP_NOTIFY="true"
export APP_ID="%app_id"
export APP_CLI="zed"
export APP_ICON="%app_id"
export APP_ARGS="%%U"
export APP_NAME="Zed"
export BRANDING_LIGHT="#99c1f1"
export BRANDING_DARK="#1a5fb4"
mkdir -p %buildroot%_desktopdir %buildroot%_datadir/metainfo
envsubst < crates/zed/resources/zed.desktop.in > %buildroot%_desktopdir/%app_id.desktop
envsubst < crates/zed/resources/flatpak/zed.metainfo.xml.in > %buildroot%_datadir/metainfo/%app_id.metainfo.xml
./update-metadata-releases.py %_specdir/%name.spec %buildroot%_datadir/metainfo/%app_id.metainfo.xml

%files
# some licenses files have copyrights
%doc LICENSE-AGPL LICENSE-APACHE README.md assets/licenses.md
%_libexecdir/zed-editor
%_bindir/zed
%_desktopdir/%app_id.desktop
%_datadir/metainfo/%app_id.metainfo.xml
%_iconsdir/hicolor/*/apps/%app_id.png

%changelog
