Name: zsh
Version: 5.9
Release: alt2
Epoch: 1

Summary: A shell with lots of features
License: ALT-Zsh
Group: Shells

Url: http://www.zsh.org
Source: %name-%version.tar
Patch: zsh-%version-%release.patch
Patch5: alt-packaging-0001-compaudit-fix-zsh-executable-discovery-if-proc-missing.patch

Patch101: alt-rpm-0001-_rpm-complete-q-lastchange.patch
Patch102: alt-rpm-0002-_rpm-optionally-complete-rpm-ba-and-similar.patch

Provides: zsh-doc = %epoch:%version
Obsoletes: zsh-doc < %epoch:%version

# Automatically added by buildreq on Thu Jan 16 2014
# optimized out: gnu-config groff-base less libncurses-devel libtinfo-devel makeinfo
BuildRequires: libcap-devel libgdbm-devel libncursesw-devel libpcre-devel man yodl makeinfo

# For make check
BuildRequires(pre): /dev/pts
# For the egrep progs in %%check.
BuildRequires(pre): /proc
BuildRequires: psmisc

%description
Zsh is a UNIX command interpreter (shell) usable as an interactive
login shell and as a shell script command processor.  Of the standard
shells, zsh most closely resembles ksh but includes many enhancements.
Zsh has command-line editing, built-in spelling correction, programmable
command completion, shell functions (with autoloading), a history
mechanism, and a lots of other features.

%prep
%setup
%patch -p1
%patch5 -p1
%patch101 -p1
%patch102 -p1
rm config.guess config.sub

%build
%autoreconf

# Disable libnsl/NIS support.
export ac_cv_search_yp_all=no zsh_cv_sys_nis=no zsh_cv_sys_nis_plus=no

# YODL is not required, pre-generated man pages are shipped.
export YODL=yodl PDFETEX=pdfetex TEXI2PDF=texi2pdf

# Avoid autoconf thinking it should strip when linking.
export LDFLAGS=

# Use getcwd(3).
export zsh_cv_use_getcwd=yes

%configure \
	--enable-cflags="%optflags" \
	--enable-etcdir=%_sysconfdir \
	--enable-fndir=%_datadir/zsh \
	--enable-scriptdir=%_datadir/zsh/scripts \
	--enable-site-fndir=/usr/local/share/zsh \
	--enable-site-scriptdir=/usr/local/share/zsh/scripts \
	--enable-additional-fpath=%_datadir/zsh/site-functions \
	--enable-function-subdirs \
	--enable-maildir-support \
	--with-curses-terminfo \
	--with-tcsetpgrp \
	--enable-cap \
	--enable-pcre \
	--enable-multibyte \
	%{?_enable_debug: --enable-zsh-{,mem-,hash-}debug } \
	%{?_enable_debug: --enable-zsh-{mem-warning,secure-free} } \
	#

# We don't expect that something is broken.
grep '^#define.*BROKEN' config.h && exit 1

%make_build MODDIR=%_libdir all info
%make_build MODDIR=%_libdir -C Etc

%install
# That script hardcodes the locale for col(1). Sad!
sed -i "/LANG/s/'C'/'C.UTF-8'/" Util/helpfiles

%makeinstall_std MODDIR=%_libdir install.info

# Relocate to /bin.
mkdir -p %buildroot/bin
mv %buildroot%_bindir/zsh %buildroot/bin/zsh
ln -s "$(relative /bin/zsh %_bindir/zsh)" %buildroot%_bindir/zsh

# Configuration files.
mkdir -p %buildroot%_sysconfdir/zshrc.d
for f in zshenv zprofile zshrc zlerc zlogout; do
	install -p -m644 zcfg/$f %buildroot%_sysconfdir/$f
done

# Fix paths.
find %buildroot%_datadir/zsh -type f -print0 |
	xargs -r0 grep -FZl /usr/local/bin/zsh |
	xargs -r0 subst -p s:/usr/local/bin/zsh:/bin/zsh:g

# Resolve absolute path of zsh binary in compaudit to power Patch5.
find %buildroot%_datadir/zsh -type f -name compaudit -print0 |
	xargs -r0 -n1 sed -i s:@packaged_zsh_executable@:%_bindir/zsh:

# Drop useless crap
rm -f %buildroot%_datadir/zsh/Completion/Linux/_rpmbuild

%check
# Tests use egrep/fgrep and ensure standard error contents are fixed.
mkdir -p %_tmppath/progs
cat >%_tmppath/progs/egrep <<EOF
#!/bin/sh -e
[ -d /proc/\$\$ ] && pstree -Upsa \$\$ >>%_tmppath/progs/log-egrep-calls
exec grep -E "\$@"
EOF
chmod +x %_tmppath/progs/egrep
cat >%_tmppath/progs/fgrep <<EOF
#!/bin/sh -e
[ -d /proc/\$\$ ] && pstree -Upsa \$\$ >>%_tmppath/progs/log-fgrep-calls
exec grep -F "\$@"
EOF
chmod +x %_tmppath/progs/fgrep
PATH="%_tmppath/progs:$PATH" make check

if [ -r %_tmppath/progs/log-egrep-calls ]; then
echo '-- `make check` has called egrep the following amount of times:'
cat %_tmppath/progs/log-egrep-calls
fi
if [ -r %_tmppath/progs/log-fgrep-calls ]; then
echo '-- `make check` has called fgrep the following amount of times:'
cat %_tmppath/progs/log-fgrep-calls
fi

%files
/bin/zsh
%_bindir/zsh
%_libdir/zsh/
%_datadir/zsh/
%config(noreplace) %_sysconfdir/z*[a-z]
%_man1dir/zsh*.*
%_infodir/zsh.info*
%doc LICENCE META-FAQ NEWS README StartupFiles/z*
%doc Etc/BUGS Etc/CONTRIBUTORS Etc/FAQ Etc/STD-TODO Etc/TODO

%changelog
