%define _metainfodir %_datadir/metainfo

Name: CGenius
Version: 3.5.0
Release: alt1

Summary: the clone of Commander Keen
License: GPL2
Group: Games/Arcade
Url: http://clonekeenplus.sourceforge.net

Source: https://gitlab.com/Dringgstein/Commander-Genius/-/archive/v%version/Commander-Genius-v%version.tar.bz2

# Automatically added by buildreq on Fri Feb 08 2019
# optimized out: cmake-modules glibc-kernheaders-generic glibc-kernheaders-x86 libSDL2-devel libX11-devel libcrypt-devel libsasl2-3 libstdc++-devel python-base python-modules python3 python3-base sh4 xorg-proto-devel
BuildRequires: boost-devel-headers cmake gcc-c++ libSDL2_image-devel libSDL2_mixer-devel libSDL2_ttf-devel libcurl-devel python3-dev zlib-devel

%description
Commander Genius is an open-source clone of Commander Keen (1-6, Dreams) which
allows you to play these episodes and some of the mods made for them. All of
the original data files are required to do so, however, we convienently provde
a store where you can get some of the games including Episode 1, 4 and Dreams
for your enjoyment. There are also mods that can be downloaded direclty.


- About -
=========
So far Commander Keen 1-6 are fully supported. There are some smaller missing
features like PaddleWar, but the whole gameplay is there.

Keen Dreams is starting to work but still might have most of the issues.
So far you can play it to the end. Also the menu lacks of a lot of features.
Please configure input and sounds using the other games.

There is an alternative called Reflection Keen which supports Keen Dreams on
which the code is based.

Commander Genius runs on Linux/X11, Windows, Android, with plans to release
on other platforms in the future. If you think you would like to port it,
please send us a message and we will do our best to help you.

- Features -
============
The main goal of Commander Genius is to copy the original gameplay feeling as
much as possible,Level No. 15 and extend it further so you get a native
implementation with even more features like:

- Mod Support with nice extras
- OpenGL Acceleration
- SDL 2.0 Support
- New graphical effects
- Multiplayer Support (Up to four players)
- High Quality Packs which make the game look better,
  provide better sounds and even music you might that never existed in the
  original games
- Ingame Menu for vorticons Keen as well as a new HUD
- Named save slots
- Unrestricted Joystick Support
- and much more

%package hqp
Group: Games/Arcade
Summary: High Quality Pack for CGenius, the clone of Commander Keen
BuildArch: noarch
Requires: %name >= %version

%description hqp
The High Quality Pack provides extra resources for Commander Genius like music
and extra sound effects and svga graphics. When installed, you can hear music
in the first three episodes of the game. High quality SVGA tilesets have been
added to Episode 1, 2, 3 and 4 so far. More is about to come!

%prep
%setup -n Commander-Genius-v%version
rm -rf Build dlls

%build
%cmake \
	-DGAMES_SHAREDIR=/usr/share/games \

%cmake_build

%install
%cmake_install
install -m644 -D src/CGLogo.png %buildroot%_iconsdir/hicolor/512x512/apps/CGLogo.png
cp -a hqp/{games,global} %buildroot%_gamesdatadir/commandergenius/

%files
%doc %_cmake__builddir/README* hqp/Readme* COPYRIGHT changelog.txt
%_gamesbindir/*
%_desktopdir/*.desktop
%_gamesdatadir/commandergenius
%_iconsdir/hicolor/512x512/apps/CGLogo.png
%_iconsdir/hicolor/*/apps/cg.*.png
%_metainfodir/io.sourceforge.clonekeenplus.appdata.xml
%exclude %_gamesdatadir/commandergenius/games
%exclude %_gamesdatadir/commandergenius/global/music
%exclude %_gamesdatadir/commandergenius/global/snd


%files hqp
%_gamesdatadir/commandergenius/games
%_gamesdatadir/commandergenius/global/music
%_gamesdatadir/commandergenius/global/snd

%changelog
