# Unpackaged files in buildroot should terminate build
%define _unpackaged_files_terminate_build 1

Name: CuraEngine
Epoch: 1
Version: 5.4.0
Release: alt1

Summary: Engine for processing 3D models into G-code instructions for 3D printers
License: AGPL-3.0-or-later
Group: Engineering
Url: https://github.com/Ultimaker/CuraEngine

# Source-url: https://github.com/Ultimaker/%name/archive/refs/tags/%version.tar.gz
Source: %name-%version.tar

# Cmake bits taken from 4.13.1, before upstream went nuts with conan
Source2: FindGMock.cmake
Source3: FindPolyclipping.cmake
Source4: FindStb.cmake
Source5: CMakeLists.txt
Source6: CPackConfig.cmake

# This is some kind of "public" layer of a private logging thing
# It's header-only and not usable as a system library,
# so I (churchyard) decided to bundle it for now. Shame on me.
# It's AGPL-3.0-or-later.
%global scripta_version c378c837eeb505146ab67abe0904bfed2099128f
# Source7-url: https://github.com/Ultimaker/Scripta_public/archive/%{scripta_version}/Scripta_public-%{scripta_version}.tar.gz
Source7: Scripta_public.tar

Patch2: %name-static-libstdcpp.patch
Patch3: %name-5.4.0-fmt10.patch

BuildRequires(pre): rpm-macros-cmake
BuildRequires: gcc-c++
BuildRequires: cmake
BuildRequires: protobuf-compiler
BuildRequires: pkgconfig(protobuf)
BuildRequires: libpolyclipping-devel
BuildRequires: pkgconfig(RapidJSON)
BuildRequires: libArcus-devel
BuildRequires: libstb-devel
BuildRequires: libfmt-devel
BuildRequires: libspdlog-devel
BuildRequires: boost-devel-headers
BuildRequires: librange-v3-devel
BuildRequires: boost-polygon-devel

%description
CuraEngine is a powerful, fast and robust engine for processing 3D
models into 3D printing instruction for Ultimaker and other GCode
based 3D printers. It is part of the larger open source project
called "Cura".

The CuraEngine is a C++ console application for 3D printing GCode
generation. It has been made as a better and faster alternative
to the old Skeinforge engine.

%prep
%setup

mkdir cmake
cp -a %SOURCE2 %SOURCE3 %SOURCE4 cmake
rm -rf CMakeLists.txt
cp -a %SOURCE5 %SOURCE6 .

tar xf %SOURCE7
mv Scripta_public/include/scripta/ include

%autopatch -p1

# bundled libraries
rm -rf libs

%build
%cmake -DBUILD_SHARED_LIBS:BOOL=OFF \
       -DSET_RPATH:BOOL=OFF \
       -DCURA_ENGINE_VERSION:STRING=%version \
       -DUSE_SYSTEM_LIBS:BOOL=ON \
       -DCMAKE_CXX_FLAGS_RELEASE_INIT:STRING="%optflags -fPIC" \
       -DStb_INCLUDE_DIRS:PATH=%_includedir/stb

%cmake_build

%install
%cmake_install

%check
# Smoke test
%buildroot%_bindir/%name help

%files
%_bindir/%name
%doc README.md

%changelog
