%define _unpackaged_files_terminate_build 1
%define soname %version
%def_enable openmp

Name: SimGear
Version: 2024.1.1
Release: alt1

Summary: Simulator Construction Tools
License: GPL-2.0-or-later
Group: System/Libraries
Url: https://www.flightgear.org
Vcs: https://gitlab.com/flightgear/SimGear.git

Source: %name-%version.tar
Patch0: simgear-3.2.0-fedora-format.patch
Patch1: simgear-3.6.0-fedora-aarch64.patch

BuildRequires: boost-devel-headers
BuildRequires: cmake
BuildRequires: cmake libapr1-devel
BuildRequires: gcc-c++
BuildRequires: libGLU-devel
BuildRequires: libOpenSceneGraph-devel
BuildRequires: libXi-devel
BuildRequires: libXt-devel
BuildRequires: libalut-devel
BuildRequires: libapr1-devel
BuildRequires: libcurl-devel
BuildRequires: libexpat-devel
BuildRequires: liblzma-devel
BuildRequires: libstdc++-devel
BuildRequires: zlib-devel
%if_enabled openmp
BuildRequires: libgomp-devel
%endif

%ifarch %e2k
# had to disable in OpenSceneGraph => unmets followed up
%global __find_debuginfo_files %nil
%endif

%description
SimGear is a set of open-source libraries designed to be used
as building blocks for quickly assembling 3d simulations, games,
and visualization applications.

%package -n libSimGearCore%soname
Summary: Core library for SimGear simulation framework
Group: System/Libraries

%description -n libSimGearCore%soname
Provides the core functionality of the SimGear simulation
framework. It includes essential components such as math utilities,
data structures, and low-level simulation logic. This library serves
as the foundation for building complex 3D simulations, games, and
visualization applications.

%package -n libSimGearScene%soname
Summary: Scene management library for SimGear simulations
Group: System/Libraries

%description -n libSimGearScene%soname
Provides advanced scene management capabilities for the SimGear
simulation framework. It includes features for handling 3D models,
terrain, lighting, and other visual elements required in complex
simulations. This library helps developers create immersive and
visually appealing 3D environments for their applications.

%package -n libsimgear-devel
Summary: Simulation library (development part)
Group: Development/C
Provides: SimGear = %version
Provides: SimGear-devel = %version
Obsoletes: SimGear-devel < 1.0.0
Conflicts: SimGear-devel < 1.0.0

%description -n libsimgear-devel
SimGear is a set of open-source libraries designed to be used as
building blocks for quickly assembling 3d simulations, games,
and visualization applications.

This package contains header files for SimGear.

%prep
%setup
%autopatch -p1

rm -rf \
  3rdparty/expat \
  #

%build
%add_optflags %optflags_shared
%cmake \
%ifarch x86_64 aarch64 %e2k
	-DENABLE_SIMD_CODE=ON \
%endif
	-DCMAKE_BUILD_TYPE=Release \
	-DCMAKE_C_FLAGS_RELEASE="-DNDEBUG" \
	-DCMAKE_CXX_FLAGS_RELEASE="-DNDEBUG" \
%if_enabled openmp
	-DENABLE_OPENMP=ON \
%endif
	-DSIMGEAR_SHARED=ON \
	-DSYSTEM_EXPAT=ON \
	-DENABLE_TESTS=OFF
%cmake_build

%install
%cmake_install

%files -n libSimGearCore%soname
%_libdir/libSimGearCore.so.%{soname}*

%files -n libSimGearScene%soname
%_libdir/libSimGearScene.so.%{soname}*

%files -n libsimgear-devel
%_libdir/*.so
%_includedir/simgear
%_libdir/cmake/%name/

%changelog
