Name: acct
Version: 6.6.4
Release: alt1

Summary: Utilities for monitoring process activities.
License: GPLv3+
Group: Monitoring
Url: http://www.gnu.org/software/acct/

# ftp://ftp.gnu.org/gnu/acct/acct-%version.tar.gz
Source: acct-%version.tar

Source1: mklog.sh
Source2: acct.init
Source3: acct.service
Source4: acct.log
Source5: dump-acct.8

Patch1: acct-owl-doc.patch
Patch2: acct-alt-program_name.patch
Patch3: acct-rh-doc.patch
patch4: acct-rh-ub.patch
Patch5: acct-deb-alt-doc.patch
Patch6: acct-deb-alt-cross-build-support.patch

Provides: psacct = %version-%release
Obsoletes: psacct < %version-%release

BuildRequires: makeinfo

%description
The acct package contains several utilities for monitoring process
activities, including ac, lastcomm, accton and sa.  The ac command
displays statistics about how long users have been logged on.  The
lastcomm command displays information about previous executed commands.
The accton command turns process accounting on or off.  The sa command
summarizes information about previously executed commands.

%prep
%setup
rm *.info
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1
%patch5 -p1
%patch6 -p1

%build
%autoreconf
%configure --enable-linux-multiformat
%make_build

%install
mkdir -p %buildroot{/sbin,/var/account}
%makeinstall_std
install -pm644 %_sourcedir/dump-acct.8 %buildroot%_man8dir/

# These come from SysVinit.
mv %buildroot%_bindir/last %buildroot%_bindir/last-acct
mv %buildroot%_man1dir/last.1 %buildroot%_man1dir/last-acct.1

# Move accton to /sbin, leaving historical symlink
mv %buildroot%_sbindir/accton %buildroot/sbin/accton
ln -r -s %buildroot/sbin/accton %buildroot%_sbindir/

touch %buildroot/var/account/{p,usr,sav}acct
install -pD -m755 %_sourcedir/acct.init \
	%buildroot%_initdir/acct
install -pD -m644 %_sourcedir/acct.service \
	%buildroot%_unitdir/acct.service
install -pD -m640 %_sourcedir/acct.log \
	%buildroot%_sysconfdir/logrotate.d/acct
install -pm700 %_sourcedir/mklog.sh \
	%buildroot/sbin/acct-mklog

%post
/sbin/acct-mklog {p,usr,sav}acct
%post_service acct

%preun
%preun_service acct

%files
%config(noreplace) %_sysconfdir/logrotate.d/acct
%_initdir/acct
%_unitdir/acct.service
/sbin/*
%_bindir/*
%_sbindir/*
%_infodir/*.info*
%_mandir/man?/*
%attr(700,root,root) %dir /var/account
%attr(600,root,root) %ghost /var/account/*
%doc AUTHORS README NEWS ChangeLog TODO

%changelog
