Group: Games/Other
# BEGIN SourceDeps(oneline):
BuildRequires: /usr/bin/desktop-file-install unzip
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           alex4
Version:        1.0
Release:        alt2_36
Summary:        Alex the Allegator 4 - Platform game
License:        GPL+
URL:            https://obiot.github.io/Alex4-WE/readme.html
Source0:        http://downloads.sf.net/allegator/Alex4/source%%20and%%20data/alex4src_data.zip
Source1:        alex4.desktop
Source2:        alex4.png
Source3:        alex4.appdata.xml
Patch0:         alex4-unix.patch
Patch1:         alex4-allegro-4.2.patch
Patch2:         alex4-dot-files-endian-clean.patch
Patch3:         alex4-fsf-address.patch
Patch4:         alex4-ini-comment.patch
Patch5:         alex4src-warnings.patch
Patch6:         alex4-fcommon-fix.patch
BuildRequires:  gcc
BuildRequires:  liballegro-devel dumb-devel desktop-file-utils libappstream-glib
Requires:       icon-theme-hicolor
Source44: import.info
Patch33: alex4-alt-allegro-4.4.patch

%description
In the latest installment of the series Alex travels through the jungle in
search of his kidnapped girlfriend. Plenty of classic platforming in four
nice colors guaranteed!


%prep
%setup -q -n alex4src
%patch0 -p1
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1
%patch5 -p1
%patch6 -p1

sed -i 's/\r//' *.txt *.ini

# as-needed
sed -i -e 's,$(CC) $(LDFLAGS) -o $@ $^,$(CC) -o $@ $^ $(LDFLAGS),' src/Makefile
# glibc-2.34
sed -i 's,^LDFLAGS = \(.*\S\)\(\s*\)$,LDFLAGS = \1 -lm\2,' src/Makefile

%patch33 -p1

%build
pushd src
%make_build PREFIX=%{_prefix} \
  CFLAGS="$RPM_OPT_FLAGS -Wno-deprecated-declarations -Wno-unused-result -DALLEGRO_FIX_ALIASES"
popd


%install
pushd src
make install PREFIX=$RPM_BUILD_ROOT%{_prefix}
popd

# below is the desktop file and icon stuff.
mkdir -p $RPM_BUILD_ROOT%{_datadir}/applications
desktop-file-install --dir $RPM_BUILD_ROOT%{_datadir}/applications \
  %{SOURCE1}
mkdir -p $RPM_BUILD_ROOT%{_datadir}/icons/hicolor/64x64/apps
install -p -m 644 %{SOURCE2} \
  $RPM_BUILD_ROOT%{_datadir}/icons/hicolor/64x64/apps
mkdir -p $RPM_BUILD_ROOT%{_datadir}/appdata
install -p -m 644 %{SOURCE3} $RPM_BUILD_ROOT%{_datadir}/appdata
appstream-util validate-relax --nonet \
  $RPM_BUILD_ROOT%{_datadir}/appdata/%{name}.appdata.xml


%files
%doc license.txt readme.txt alex4.ini
%{_bindir}/%{name}
%{_datadir}/%{name}
%{_datadir}/appdata/%{name}.appdata.xml
%{_datadir}/applications/%{name}.desktop
%{_datadir}/icons/hicolor/64x64/apps/%{name}.png


%changelog
