%def_with systemd

Name: alsa-utils
Version: 1.2.13
Release: alt1
Epoch: 1

Summary: Advanced Linux Sound Architecture (ALSA) utils
License: GPLv2+
Group: System/Kernel and hardware

Url: http://www.alsa-project.org
Source: %name-%version.tar
Patch: %name-%version-%release.patch
Packager: Valery Inozemtsev <shrek@altlinux.ru>

Requires: dialog
Requires: tree
Obsoletes: alsa2-utils < 0.9.4
Provides: alsa2-utils = %version
Conflicts: alsa-utils < 1.0.9a-alt1

BuildRequires: intltool libalsa-devel libncursesw-devel xmlto libfftw3-devel
%{?_with_systemd:BuildRequires: systemd-devel}

Obsoletes: alsa-bat <= 1.1.0
Provides: alsa-bat = %version

%add_findreq_skiplist %_sbindir/alsa-info.sh

%description
Advanced Linux Sound Architecture (ALSA) utils. Modularized
architecture with support for a large range of ISA and PCI cards.
Fully compatible with OSS/Lite but contains many enhanced features.

%package -n aplay
Summary: play utility for ALSA
Group: Sound

%description -n aplay
This package contains minimal client utility for ALSA:
"aplay" is traditional "play" equivalent.

%package -n amixer
Summary: Command-line mixer for ALSA soundcard driver
License: GPL-2.0-or-later
Group: Sound

%description -n amixer
amixer allows command-line control of the mixer for the ALSA soundcard
driver.  amixer supports multiple soundcards.

%prep
%setup
%patch -p1
touch config.rpath

%build
%autoreconf
%configure \
	--with-curses=ncursesw \
	--with-udev-rules-dir=%_udevrulesdir \
	%{?_with_systemd:--with-systemdsystemunitdir=%_unitdir} \
	--disable-alsaconf
%make_build

%install
%makeinstall_std
%find_lang --with-man --output=%name.lang %name

%files -f %name.lang
%doc ChangeLog README*
%_udevrulesdir/*.rules
%_bindir/*
%exclude %_bindir/aplay
%exclude %_bindir/arecord
%exclude %_bindir/amixer
%_sbindir/*
%_bindir/speaker-test
%_libdir/alsa-topology/*.so
%_datadir/alsa/init
%_datadir/sounds/alsa
%_man1dir/*.1*
%exclude %_man1dir/aplay.1*
%exclude %_man1dir/arecord.1*
%exclude %_man1dir/amixer.1*
%_man7dir/*.7*

%if_with systemd
%_unitdir/alsa-restore.service
%_unitdir/alsa-state.service
%_unitdir/sound.target.wants/alsa-restore.service
%_unitdir/sound.target.wants/alsa-state.service
%endif

%files -n aplay
%_bindir/aplay
%_bindir/arecord
%_man1dir/aplay.1*
%_man1dir/arecord.1*

%files -n amixer
%_bindir/amixer
%_man1dir/amixer.1*

%changelog
