%define _altdata_dir %_datadir/alterator

Name: alterator-setup
Version: 0.4.5
Release: alt1

Summary: Perform initial setup of an OEM installation (warning!)
License: GPLv2
Group: System/Configuration/Other

Url: http://www.altlinux.org/Alterator
Source: %name-%version.tar

BuildArch: noarch
BuildPreReq: alterator >= 4.10-alt6
BuildRequires: rpm-macros-alterator

Requires: libshell
Requires: alterator-l10n >= 2.5-alt1
Requires: alterator-browser-qt >= 2.17.0
Requires: alterator-lookout => 2.4-alt1
Requires: alterator-wizardface
Requires: alterator-notes
Requires: alterator-sysconfig
Requires: alterator-datetime
Requires: alterator-root
Requires: alterator-users

Requires(post): chkconfig service
Requires(preun): chkconfig service

Obsoletes: alterator-setup-x11vnc < %EVR

%description
%summary

WARNING: you really don't want to install this package
into an already configured system as it may spoil the
next boot!  Given that its sole purpose is the _initial_
configuration of a new system (like setting root password)
nobody should need that on an up-and-running host.

%package -n installer-feature-%name-stage2
Summary: Perform initial setup of an OEM installation (warning!)
Group: System/Configuration/Other

%description -n installer-feature-%name-stage2
Perform initial setup of an OEM installation.
This postinstall script for installer.

%package -n installer-feature-%name-x11vnc-stage2
Summary: Perform initial setup of an OEM installation through VNC (warning!)
Group: System/Configuration/Other

%description -n installer-feature-%name-x11vnc-stage2
Perform initial setup of an OEM installation through VNC.
This postinstall script for installer.

%prep
%setup

%install
%makeinstall

cat >> %buildroot%_sysconfdir/alterator-setup/config << EOF
# erase %name and related packages
REMOVE_SELF=1
#ALTERATOR_SETUP_VNC=1
EOF

%files
%dir %_sysconfdir/%name
%config(noreplace) %_sysconfdir/%name/config
%config(noreplace) %_sysconfdir/%name/steps
%_initdir/setup
%_sbindir/%name
%_sbindir/%name-prep
%_alterator_datadir/steps/*
%_alterator_datadir/ui/*
%_alterator_libdir/hooks/*/*
%_alterator_backend3dir/*
%_datadir/alterator-setup/
/lib/systemd/system/setup.service
/lib/systemd/system/setup.target

%files -n installer-feature-%name-stage2
%_datadir/install2/postinstall.d/91-alterator-setup

%files -n installer-feature-%name-x11vnc-stage2
%_datadir/install2/postinstall.d/92-alterator-setup-vnc

%post
if [ -x /sbin/sd_booted ]; then
/sbin/sd_booted || %post_service setup
fi

# package is removed in postinstall hook, but
# 'systemd stop' stops whole setup.service with hook.
%preun
if [ -x /sbin/sd_booted ]; then
/sbin/sd_booted || %preun_service setup
fi

%changelog
