# Unpackaged files in buildroot should terminate build
%define _unpackaged_files_terminate_build 1

%ifndef distro
%define distro p11
%endif
%ifndef timestamp
%define timestamp 20240523
%endif
%ifndef dtext
%define dtext %distribution %distro
%endif
%ifndef text_summary
%define text_summary %dtext
%endif
%ifndef text_descr
%define text_descr %dtext
%endif
%ifndef text_file
%define text_file %dtext (Salvia)
%endif
%ifndef provide_list
%define provide_list altlinux fedora redhat system
%endif
%ifndef obsolete_list
%define obsolete_list altlinux-4.0 altlinux-release altlinux-release-4.0 altlinux-release-4.1 altlinux-release-5.0 altlinux-release-5.1 altlinux-release-c6 altlinux-release-chainmail altlinux-release-desktop altlinux-release-homeros altlinux-release-hpc altlinux-release-junior altlinux-release-master altlinux-release-office-server altlinux-release-p5 altlinux-release-p6 altlinux-release-p7 altlinux-release-p8 altlinux-release-p9 altlinux-release-p10 altlinux-release-school-server altlinux-release-server altlinux-release-skif altlinux-release-small_business altlinux-release-t6 altlinux-release-terminal fedora-release redhat-release
%endif
%ifndef conflicts_list
%define conflicts_list altlinux-release-sisyphus
%endif

Name: altlinux-release-p11
Version: %timestamp
Release: alt1

Summary: %text_summary release file
License: GPL
Group: System/Configuration/Other
BuildArch: noarch

Provides: %(for n in %provide_list; do echo -n "$n-release = %version-%release "; done)
Obsoletes: %obsolete_list
Conflicts: %conflicts_list

%description
%text_descr release file.

%install
install -pD -m644 /dev/null %buildroot%_sysconfdir/buildreqs/packages/ignore.d/%name
echo "%text_file" >%buildroot%_sysconfdir/altlinux-release
for n in fedora redhat system; do
	ln -s altlinux-release %buildroot%_sysconfdir/$n-release
done

cat << __EOF__ > %buildroot%_sysconfdir/os-release
NAME=ALT
VERSION="p11 branch"
ID=altlinux
VERSION_ID=11
PRETTY_NAME="ALT p11 branch"
ANSI_COLOR="1;33"
CPE_NAME="cpe:/o:alt:branch:11"
HOME_URL="https://en.altlinux.org/"
BUG_REPORT_URL="https://bugs.altlinux.org/"
__EOF__

mkdir -p %buildroot%_rpmmacrosdir
cat > %buildroot%_rpmmacrosdir/altlinux-release <<-__EOF__
	%%_priority_distbranch	%distro
__EOF__

%files
%_sysconfdir/*-*
%_sysconfdir/buildreqs/packages/ignore.d/*
%_rpmmacrosdir/altlinux-release

%changelog
