%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%set_verify_elf_method strict

%define origname AssaultCube_v1.2.0.2
%define rev 779627cb

# clang doesn't know used LTO flags
%global optflags_lto %nil

Name: assaultcube
Version: 1.2.0.2
Release: alt8.%rev
Summary: Free first-person-shooter based on the game Cube
Group: Games/Arcade
License: Creative Commons
Url: https://assault.cubers.net

ExcludeArch: ppc64le

# git: https://github.com/assaultcube/AC
# http://assault.cubers.net/download.html/%origname.tar.bz2
Source: %name-%version.tar
Source1: assaultcube_client.sh
Source2: assaultcube_server.sh
Source3: %name.desktop
Source4: %name.png

Patch1: %name-%version-alt-gcc.patch

# Automatically added by buildreq on Sun Mar 23 2014
# optimized out: libGL-devel libGLU-devel libSDL-devel libX11-devel libcloog-isl4 libogg-devel llvm xorg-xproto-devel
BuildRequires: clang libSDL_image-devel libcurl-devel libopenal-devel libstdc++-devel libvorbis-devel zlib-devel
BuildRequires: gnu-config
%ifarch %e2k
# because of the missing <new>
BuildRequires: gcc-c++
# -O3 is the default for e2k
%global _optlevel 2
%endif

Requires: %name-data = %version

%description
AssaultCube,formerly ActionCube, is a free first-person-shooter based on
the game Cube. Set in a realistic looking environment, as far as that's
possible with this engine, while gameplay stays fast and arcade. This
game is all about team oriented multiplayer fun.

%prep
%setup
%patch1 -p2
# the provided config is outdated and doesn't know about e2k, LoongArch
cp /usr/share/gnu-config/config.{guess,sub} source/enet/

%build
%add_optflags -D__STRICT_ANSI__
%add_optflags -D_FILE_OFFSET_BITS=64
%make_build -C source/src CFLAGS="%optflags" CXXOPTFLAGS="%optflags" CXXFLAGS="%optflags"

%install
mkdir -p %buildroot%_bindir
install -pD -m 755 %SOURCE1 %buildroot%_bindir/assaultcube_client
install -pD -m 755 %SOURCE2 %buildroot%_bindir/assaultcube_server

mkdir -p %buildroot%_desktopdir
install -pD -m 644 %SOURCE3 %buildroot%_desktopdir/%name.desktop

mkdir -p %buildroot%_liconsdir
install -pD -m 644 %SOURCE4 %buildroot%_liconsdir/%name.png

mkdir -p %buildroot%_docdir/%name/
mkdir -p %buildroot%_gamesdatadir/%name/

mv source/src/ac_client %buildroot%_bindir/
mv source/src/ac_server %buildroot%_bindir/
mv docs %buildroot/%_docdir/%name/
mv mods %buildroot/%_docdir/%name/
mv README.html %buildroot/%_docdir/%name/

%files
%_bindir/*
%_docdir/%name
%_desktopdir/%name.desktop
%_liconsdir/*.png

%changelog
