Name: autogen
Version: 5.18.16
Release: alt1

Summary: AutoGen - The Automated Program Generator
License: GPL-3.0-or-later AND GPL-2.0-or-later AND LGPL-2.1-or-later AND LGPL-2.0-or-later AND BSD-2-Clause
Group: Development/Other
Url: http://www.gnu.org/software/autogen/

Source: %name-%version.tar
Patch1: autogen-5.18.4-masquerade-deps.patch
Patch2: suse_01-autogen-catch-race-error.patch
Patch3: suse_03-gcc9-fix-wrestrict.patch
Patch4: suse_04-guile-version.patch
Patch5: suse_05-sprintf-overflow.patch
Patch6: suse_06-autogen-avoid-GCC-code-analysis-bug.patch
Patch7: suse_07-installable-programs.patch

# Automatically added by buildreq on Sun Dec 10 2017
# optimized out: glibc-kernheaders-generic glibc-kernheaders-x86 guile22 libgc-devel libgmp-devel perl perl-Encode perl-Text-Unidecode perl-Unicode-EastAsianWidth perl-Unicode-Normalize perl-libintl pkg-config python-base
BuildRequires: guile-devel libxml2-devel makeinfo texi2html
BuildRequires: /proc

%define _unpackaged_files_terminate_build 1

%description
AutoGen is a tool designed to simplify the creation and maintenance
of programs that contain large amounts of repetitious text.
It is especially valuable in programs that have several blocks of text
that must be kept synchronized.

AutoGen can now accept XML files as definition input, in addition to CGI
data (for producing dynamic HTML) and traditional AutoGen definitions.

A common example where this would be useful is in creating and
maintaining the code required for processing program options. Processing
options requires multiple constructs to be maintained in parallel
in different places in your program. Options maintenance needs to be
done countless times. So, AutoGen comes with an add-on package named
AutoOpts that simplifies the maintenance and documentation of program
options.

%package -n libopts
Summary: Command line option parser based on AutoGen
Group: Development/Other
License: LGPLv3+

%description -n libopts
AutoOpts is a very powerful command line option parser consisting of
a set of AutoGen templates and a run time library that nearly eliminates
the hassle of parsing and documenting command line options.
This package allows you to specify several program attributes, up to 100
option types and many attributes for each option.

%package -n libopts-devel
Summary: AutoGen development files and libraries
Group: Development/Other
License: LGPLv3+
Requires: libopts = %version-%release
Obsoletes: autogen-devel = %version-%release
Provides: autogen-devel = %version-%release

%description -n libopts-devel
AutoOpts is a very powerful command line option parser consisting of
a set of AutoGen templates and a run time library that nearly eliminates
the hassle of parsing and documenting command line options. This package
allows you to specify several program attributes, up to 100 option types
and many attributes for each option.

This package is needed to write programs that use AutoOpts API.

%prep
%setup
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1
%patch5 -p1
%patch6 -p1
%patch7 -p1
rm doc/autogen.info*

%build
%autoreconf
%configure \
	--disable-static
%make_build

%install
%makeinstall_std

%check
make -k check

%files
%doc AUTHORS TODO COPYING NEWS THANKS README VERSION
%_bindir/autogen
%_bindir/columns
%_bindir/getdefs
%_bindir/xml2ag
%_libdir/%name/
%dir %_datadir/%name
%_datadir/%name/*
%_infodir/%{name}*
%_man1dir/autogen.1*
%_man1dir/columns.1*
%_man1dir/getdefs.1*
%_man1dir/xml2ag.1*

%files -n libopts
%_libdir/libopts.so.*

%files -n libopts-devel
%_bindir/autoopts-config
%dir %_includedir/autoopts
%_includedir/autoopts/*
%_pkgconfigdir/autoopts.pc
%_libdir/*.so
%_datadir/aclocal/autoopts.m4
%_man1dir/autoopts-config.1.*
%_man3dir/*.3.*

%changelog
