Name: baresip
Version: 3.21.0
Release: alt1

Summary: Baresip is a portable and modular SIP User-Agent with audio and video support
License: BSD-3-Clause
Group: Communications

Url: https://github.com/baresip/baresip

#Source-url: https://github.com/baresip/baresip/archive/refs/tags/v%version.tar.gz
Source: %name-%version.tar

BuildRequires(pre): rpm-macros-cmake
BuildRequires: cmake gcc-c++ libssl-devel zlib-devel
BuildRequires: libre-devel >= 3.21.0

%add_verify_elf_skiplist %_libdir/%name/modules/*.so

%description
baresip is a bare-bones SIP user agent. It supports SIP, SDP, RTP/RTCP,
and STUN/TURN/ICE, and IPv4 and IPv6, and is RFC-compliant and has
portable C89 and C99 source code. A modular plugin architecture provides
stdio, cons, and evdev user interfaces, codec2, g711, g722, g726, ilbc, l16,
and opus codecs, alsa, pulseaudio, pipewire, jack, coreaudio, gst, portaudio,
winwave, opensles and sndio audio drivers, the audio filters, av1, h264, h265,
vp8, vp9 video codec, avformat, acvapture and v4l2 video sources, sdl2,
directfb and x11 video display drivers, and srtp media encoding.

%package devel
Summary: Development files for %name library
Group: Development/Other
Requires: %name = %version-%release

%description devel
The %name-devel package includes libraries and header files for developing
appications which use the baresip C library.

%package aac
Summary: AAC audio codec module for baresip
Group: Communications
BuildRequires: libfdk-aac-devel
Requires: %name = %version-%release

%description aac
Baresip is a portable and modular SIP User-Agent with audio and video support

This module provides the Advanced Audio Coding (AAC) audio codec.

%package alsa
Summary: ALSA audio driver module for baresip
Group: Communications
BuildRequires:  libalsa-devel
Requires: %name = %version-%release

%description alsa
Baresip is a portable and modular SIP User-Agent with audio and video support

This module provides the Advanced Linux Sound Architecture (ALSA) audio
driver.

%package av1
Summary: AV1 video codec module for baresip
Group: Communications
BuildRequires: libaom-devel
Requires: %name = %version-%release

%description av1
Baresip is a portable and modular SIP User-Agent with audio and video support

This module provides the AOMedia Video 1 (AV1) video codec.

%package avcodec
Summary: AVCodec video codec module for baresip
Group: Communications
BuildRequires: libavcodec-devel libavfilter-devel libavformat-devel libavdevice-devel
BuildRequires: libavutil-devel libswscale-devel
Requires: %name = %version-%release

%description avcodec
Baresip is a portable and modular SIP User-Agent with audio and video support

This module implements H.264 and H.265 video codecs using libavcodec from
the FFmpeg project.

%package avfilter
Summary: AVFilter video filter for baresip
Group: Communications
BuildRequires: libavcodec-devel libavfilter-devel libavformat-devel libavdevice-devel
BuildRequires: libavutil-devel libswscale-devel libswresample-devel
Requires: %name = %version-%release

%description avfilter
Baresip is a portable and modular SIP User-Agent with audio and video support

This module allows to dynamically apply complex video filter graphs to
the outcoming stream using libavfilter from the FFmpeg project.

%package avformat
Summary: AVFormat video source driver for baresip
Group: Communications
BuildRequires: libavcodec-devel libavfilter-devel libavformat-devel libavdevice-devel
BuildRequires: libavutil-devel libswscale-devel libswresample-devel
Requires: %name = %version-%release

%description avformat
Baresip is a portable and modular SIP User-Agent with audio and video support

This module provides a video source driver using libavformat from the
FFmpeg project.

%package codec2
Summary: Codec2 speech codec module for baresip
Group: Communications
BuildRequires: libcodec2-devel
Requires: %name = %version-%release

%description codec2
Baresip is a portable and modular SIP User-Agent with audio and video support

This module provides the Codec2 low-bitrate speech audio codec.

%package ctrl_dbus
Summary: D-BUS module for baresip
Group: Communications
BuildRequires: libgio-devel
Requires: %name = %version-%release

%description ctrl_dbus
Baresip is a portable and modular SIP User-Agent with audio and video support

This module provides the communication channel to control and monitor baresip via D-BUS.

%package g722
Summary: G.722 audio codec module for baresip
Group: Communications
BuildRequires: libspandsp-devel
Requires: %name = %version-%release

%description g722
Baresip is a portable and modular SIP User-Agent with audio and video support

This module provides the G.722 audio codec.

%package g726
Summary: G.726 audio codec module for baresip
Group: Communications
BuildRequires: libspandsp-devel
Requires: %name = %version-%release

%description g726
Baresip is a portable and modular SIP User-Agent with audio and video support

This module provides the G.726 audio codec.

%package gst
Summary: GStreamer audio source driver module for baresip
Group: Communications
BuildRequires: gstreamer1.0-devel
Requires: %name = %version-%release

%description gst
Baresip is a portable and modular SIP User-Agent with audio and video support

This module provides the Gstreamer framework to play external media
and provide this as an internal audio source.

%package gtk
Summary: GTK+ Menu-based User-Interface module for baresip
Group: Communications
BuildRequires: libgtk+3-devel
Requires: %name = %version-%release

%description gtk
Baresip is a portable and modular SIP User-Agent with audio and video support

This module provides a GTK+ menu-based user interface.

%package jack
Summary: JACK audio driver module for baresip
Group: Communications
BuildRequires: pkgconfig(jack)
Requires: %name = %version-%release

%description jack
Baresip is a portable and modular SIP User-Agent with audio and video support

This module provides the JACK Audio Connection Kit audio driver.

%package mpa
Summary: MPA speech and audio codec module for baresip
Group: Communications
BuildRequires: libmpg123-devel libtwolame-devel liblame-devel libspeexdsp-devel
Requires: %name = %version-%release

%description mpa
Baresip is a portable and modular SIP User-Agent with audio and video support

This module provides the MPA speech and audio codec.

%package mqtt
Summary: MQTT management module for baresip
Group: Communications
BuildRequires: libmosquitto-devel
Requires: %name = %version-%release

%description mqtt
Baresip is a modular SIP user-agent with audio and video support.

This module provides the Message Queue Telemetry Transport (MQTT)
management module.

%package opus
Summary: Opus audio codec module for baresip
Group: Communications
BuildRequires: libopus-devel
Requires: %name = %version-%release

%description opus
Baresip is a portable and modular SIP User-Agent with audio and video support

This module provides the Opus speech and audio codec.

%package pipewire
Summary: Pipewire audio driver module for baresip
Group: Communications
BuildRequires: pipewire-libs-devel
Requires: %name = %version-%release

%description pipewire
Baresip is a portable and modular SIP User-Agent with audio and video support

This module provides the Pipewire audio driver.

%package plc
Summary: Packet Loss Concealment module for baresip
Group: Communications
BuildRequires: libspandsp-devel
Requires: %name = %version-%release

%description plc
Baresip is a portable and modular SIP User-Agent with audio and video support

This module provides the Packet Loss Concealment (PLC) audio-filter using spandsp.

%package portaudio
Summary: PortAudio audio driver module for baresip
Group: Communications
BuildRequires: libportaudio2-devel
Requires: %name = %version-%release

%description portaudio
Baresip is a portable and modular SIP User-Agent with audio and video support

This module provides the PortAudio audio driver.

%package pulse
Summary: PulseAudio audio driver module for baresip
Group: Communications
BuildRequires: libpulseaudio-devel
Requires: %name = %version-%release

%description pulse
Baresip is a portable and modular SIP User-Agent with audio and video support

This module provides the PulseAudio audio driver.

%package sdl
Summary: SDL2 video output driver module for baresip
Group: Communications
BuildRequires: libSDL2-devel
Requires: %name = %version-%release

%description sdl
Baresip is a portable and modular SIP User-Agent with audio and video support

This module provides the Simple DirectMedia Layer 2.0 (SDL) video output driver.

%package snapshot
Summary: Snapshot module for baresip
Group: Communications
BuildRequires: libpng-devel
Requires: %name = %version-%release

%description snapshot
Baresip is a portable and modular SIP User-Agent with audio and video support

This module takes snapshots of the video-stream and save them as PNG images.

%package sndfile
Summary: Snapshot module for baresip
Group: Communications
BuildRequires: libsndfile-devel
Requires: %name = %version-%release

%description sndfile
Baresip is a portable and modular SIP User-Agent with audio and video support

This module provides audio filter that writes audio samples to WAV-file.

%package swscale
Summary: SWScale video filter for baresip
Group: Communications
BuildRequires: libavcodec-devel libavfilter-devel libavformat-devel libavdevice-devel
BuildRequires: libavutil-devel libswscale-devel libswresample-devel
Requires: %name = %version-%release

%description swscale
Baresip is a portable and modular SIP User-Agent with audio and video support

This module provides a video filter for scaling and pixel conversion
using libswscale from the FFmpeg project.

%package vp8
Summary: VP8 video codec module for baresip
Group: Communications
BuildRequires: libvpx-devel
Requires: %name = %version-%release

%description vp8
Baresip is a portable and modular SIP User-Agent with audio and video support

This module provides the VP8 video codec.

%package vp9
Summary: VP9 video codec module for baresip
Group: Communications
BuildRequires: libvpx-devel
Requires: %name = %version-%release

%description vp9
Baresip is a portable and modular SIP User-Agent with audio and video support

This module provides the VP9 video codec.

%package v4l2
Summary: Video4Linux video source driver module for baresip
Group: Communications
BuildRequires: libv4l-devel
Requires: %name = %version-%release

%description v4l2
Baresip is a portable and modular SIP User-Agent with audio and video support

This module provides the Video4Linux video source driver.

%package x11
Summary: X11 video output driver module for baresip
Group: Communications
BuildRequires: libXext-devel
Requires: %name = %version-%release

%description x11
Baresip is a portable and modular SIP User-Agent with audio and video support

This module provides the X11 video output driver.

%prep
%setup -q

%build
%cmake -DCMAKE_BUILD_TYPE=RelWithDebInfo
%cmake_build

%install
%cmake_install

%files
%doc CHANGELOG.md LICENSE README.md docs/examples/*
%_bindir/%name
%_libdir/lib%name.so.20*
%dir %_libdir/%name/
%dir %_libdir/%name/modules/
%_libdir/%name/modules/account.so
%_libdir/%name/modules/aubridge.so
%_libdir/%name/modules/auconv.so
%_libdir/%name/modules/aufile.so
%_libdir/%name/modules/augain.so
%_libdir/%name/modules/auresamp.so
%_libdir/%name/modules/ausine.so
%_libdir/%name/modules/cons.so
%_libdir/%name/modules/contact.so
%_libdir/%name/modules/ctrl_tcp.so
%_libdir/%name/modules/debug_cmd.so
%_libdir/%name/modules/dtls_srtp.so
%_libdir/%name/modules/ebuacip.so
%_libdir/%name/modules/echo.so
%_libdir/%name/modules/evdev.so
%_libdir/%name/modules/fakevideo.so
%_libdir/%name/modules/g711.so
%_libdir/%name/modules/httpd.so
%_libdir/%name/modules/httpreq.so
%_libdir/%name/modules/ice.so
%_libdir/%name/modules/in_band_dtmf.so
%_libdir/%name/modules/l16.so
%_libdir/%name/modules/menu.so
%_libdir/%name/modules/mixausrc.so
%_libdir/%name/modules/mixminus.so
%_libdir/%name/modules/mwi.so
%_libdir/%name/modules/natpmp.so
%_libdir/%name/modules/netroam.so
%_libdir/%name/modules/pcp.so
%_libdir/%name/modules/presence.so
%_libdir/%name/modules/rtcpsummary.so
%_libdir/%name/modules/selfview.so
%_libdir/%name/modules/serreg.so
%_libdir/%name/modules/srtp.so
%_libdir/%name/modules/stdio.so
%_libdir/%name/modules/stun.so
%_libdir/%name/modules/syslog.so
%_libdir/%name/modules/turn.so
%_libdir/%name/modules/uuid.so
%_libdir/%name/modules/vidbridge.so
%_libdir/%name/modules/vidinfo.so
%_libdir/%name/modules/vumeter.so
%_datadir/%name

%files devel
%_includedir/%name.h
%_libdir/lib%name.so
%_pkgconfigdir/lib%name.pc

%files aac
%_libdir/%name/modules/aac.so

%files alsa
%_libdir/%name/modules/alsa.so

%files av1
%_libdir/%name/modules/av1.so
	
%files avcodec
%_libdir/%name/modules/avcodec.so

%files avfilter
%_libdir/%name/modules/avfilter.so

%files avformat
%_libdir/%name/modules/avformat.so

%files codec2
%_libdir/%name/modules/codec2.so

%files ctrl_dbus
%_libdir/%name/modules/ctrl_dbus.so

%files g722
%_libdir/%name/modules/g722.so

%files g726
%_libdir/%name/modules/g726.so

%files gst
%_libdir/%name/modules/gst.so

%files gtk
%_libdir/%name/modules/gtk.so
%_desktopdir/com.github.baresip.desktop

%files jack
%_libdir/%name/modules/jack.so

%files mpa
%_libdir/%name/modules/mpa.so

%files mqtt
%_libdir/%name/modules/mqtt.so

%files opus
%_libdir/%name/modules/opus.so
%_libdir/%name/modules/opus_multistream.so

%files pipewire
%_libdir/%name/modules/pipewire.so

%files portaudio
%_libdir/%name/modules/portaudio.so

%files plc
%_libdir/%name/modules/plc.so

%files pulse
%_libdir/%name/modules/pulse.so

%files sdl
%_libdir/%name/modules/sdl.so

%files snapshot
%_libdir/%name/modules/snapshot.so

%files sndfile
%_libdir/%name/modules/sndfile.so

%files swscale
%_libdir/%name/modules/swscale.so

%files vp8
%_libdir/%name/modules/vp8.so

%files vp9
%_libdir/%name/modules/vp9.so

%files v4l2
%_libdir/%name/modules/v4l2.so

%files x11
%_libdir/%name/modules/x11.so

%changelog
