Name: bc
Version: 1.07.1
Release: alt1
Serial: 1

Summary: GNU's bc (a numeric processing language) and dc (a calculator)
License: GPL-3.0-or-later
Group: Sciences/Mathematics
Url: https://www.gnu.org/software/bc/

# https://ftp.gnu.org/gnu/bc/bc-%version.tar.gz
Source: bc-%version.tar

Patch01: 01_typo_in_bc.diff
Patch02: 02_hyphens_as_minus_in_man.diff
Patch05: 05_notice_read_write_errors.diff
Patch06: 06_read_dcrc.diff
Patch07: 07_bc_man.diff
Patch08: 08_no-make-circular-dependencies.diff

Patch11: bc-alt-texinfo.patch
Patch12: bc-owl-functions-fix.patch
Patch13: bc-rh-dc_ibase.patch

BuildRequires: bison ed flex gcc libreadline-devel makeinfo

%description
This package includes bc and dc.  bc implements a numeric processing
language with interactive execution of statements.  dc is a stack-based
calculator.  Both bc and dc support arbitrary precision arithmetic.

%prep
%setup
%patch1 -p1
%patch2 -p1
%patch5 -p1
%patch6 -p1
%patch7 -p1
%patch8 -p1

%patch11 -p1
%patch12 -p1
%patch13 -p1

rm doc/*.info
rm bc/{bc,scan}.c
find -type f -name getopt\* -delete
sed -i 's/getopt[1]\?\.c //g' lib/Makefile.am

%build
%add_optflags -fno-strict-aliasing -fno-strict-overflow -DDONTEXIT
autoreconf -fisv
export ac_cv_lib_termcap_tgetent=no ac_cv_lib_ncurses_tparm=no
%configure --with-readline
%make_build

%install
%makeinstall_std

%files
%_bindir/*
%_mandir/man?/*
%_infodir/*.info*
%doc Examples AUTHORS FAQ NEWS README

%changelog
