%ifnarch armh
%def_with check
%else
%def_without check
%endif

Name:    blosc2
Version: 2.14.4
Release: alt1

Summary: A fast, compressed, persistent binary data store library for C
License: BSD-3-Clause
Group:   System/Libraries
Url:     https://www.blosc.org/
VCS:     https://github.com/Blosc/c-blosc2

Source:  %name-%version.tar
Patch1:  0001-init_shuffle_implementation-use-a-proper-synchroniza.patch

BuildRequires(pre): cmake gcc-c++
BuildRequires: zlib-devel liblz4-devel libzstd-devel ctest

%description
C-Blosc2 is the new major version of C-Blosc, and tries hard to be backward
compatible with both the C-Blosc1 API and its in-memory format. However,
the reverse thing is generally not true for the format; buffers generated
with C-Blosc2 are not format-compatible with C-Blosc1 (i.e. forward
compatibility is not supported). In case you want to ensure full API
compatibility with C-Blosc1 API, define the BLOSC1_COMPAT symbol.

%package -n lib%name
Summary: %summary
Group: System/Libraries

%description -n lib%name
C-Blosc2 is the new major version of C-Blosc, and tries hard to be backward
compatible with both the C-Blosc1 API and its in-memory format. However,
the reverse thing is generally not true for the format; buffers generated
with C-Blosc2 are not format-compatible with C-Blosc1 (i.e. forward
compatibility is not supported). In case you want to ensure full API
compatibility with C-Blosc1 API, define the BLOSC1_COMPAT symbol.

%package -n lib%name-devel
Summary: Development files of Blosc2 library
Group: Development/C++
Requires: lib%name = %EVR

%description -n lib%name-devel
C-Blosc2 is the new major version of C-Blosc, and tries hard to be backward
compatible with both the C-Blosc1 API and its in-memory format. However,
the reverse thing is generally not true for the format; buffers generated
with C-Blosc2 are not format-compatible with C-Blosc1 (i.e. forward
compatibility is not supported). In case you want to ensure full API
compatibility with C-Blosc1 API, define the BLOSC1_COMPAT symbol.

This package contains development files of Blosc2 library.

%prep
%setup
%patch1 -p1
%ifarch %e2k
# why is libdl used but not linked?
sed -i '1i set(LIBS ${LIBS} "dl")' blosc/CMakeLists.txt
%endif

# remove bundled libraries
rm -rf internal-complibs

%build
%cmake \
        -DBUILD_STATIC=OFF \
        -DBUILD_EXAMPLES=OFF \
        -DBUILD_FUZZERS=OFF \
        -DBUILD_BENCHMARKS=OFF \
        -DPREFER_EXTERNAL_ZLIB=ON \
        -DPREFER_EXTERNAL_LZ4=ON \
        -DPREFER_EXTERNAL_ZSTD=ON
%cmake_build

%install
%cmakeinstall_std

%check
%cmake_build --target test

%files -n lib%name
%doc README.rst LICENSE.txt RELEASE_NOTES.md
%_libdir/libblosc2.so.*

%files -n lib%name-devel
%_libdir/libblosc2.so
%dir %_includedir/blosc2
%_includedir/blosc2.h
%_includedir/b2nd.h
%_includedir/blosc2
%_pkgconfigdir/blosc2.pc
%dir %_libdir/cmake
%_libdir/cmake/Blosc2

%changelog
