%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1

%define git %nil
%define _libexecdir %_prefix/libexec
%def_enable midi
%def_enable obex
%def_enable btpclient
# since 5.44 the following tools marked as deprecated:
# hciattach hciconfig hcitool hcidump rfcomm sdptool ciptool gatttool
%def_enable deprecated
%def_enable experimental
%ifarch %e2k %ix86 %arm mipsel
%def_disable testing
%else
%def_enable testing
%endif

Name: bluez
Version: 5.84
Release: alt3

Summary: Bluetooth utilities
License: GPL-2.0-or-later
Group: Networking/Other

Url: http://www.bluez.org/
Source: %name-%version.tar
Patch: %name-%version-%release.patch
Packager: L.A. Kostis <lakostis@altlinux.org>

Obsoletes: obex-data-server < 0.4.6-alt3
Conflicts: udev-extras < 169

BuildRequires: glib2-devel libudev-devel libdbus-devel libreadline-devel
BuildRequires: systemd-devel gtk-doc python3-module-docutils
BuildRequires: libcups-devel
%{?_enable_midi:BuildRequires: libalsa-devel}
%{?_enable_obex:BuildRequires: libical-devel libicu-devel}
%{?_enable_btpclient:BuildRequires: libell-devel >= 0.39}
# for check
BuildRequires: /proc

%description
Bluetooth protocol stack for Linux

%package -n lib%name
Summary: Libraries for use in Bluetooth applications
Group: System/Libraries
Obsoletes: lib%{name}4

%description -n lib%name
Libraries for use in Bluetooth applications

%package -n lib%name-devel
Summary: Development libraries for Bluetooth applications
Group: Development/C
Requires: lib%name = %EVR

%description -n lib%name-devel
lib%name-devel contains development libraries and headers for
use in Bluetooth applications

%package cups
Summary: CUPS printer backend for Bluetooth printers
Group: Networking/Other
Requires: %name = %EVR

%description cups
This package contains the CUPS backend

%package btpclient
Summary: Tester protocol for Bluetooth stack client
Group: Networking/Other
Requires: %name = %EVR

%description btpclient
BTP stands for Bluetooth Tester Protocol and aims at automated testing of BT
stack. BTP is binary protocol and is already implemented in Zephyr Project.

https://github.com/zephyrproject-rtos/zephyr/blob/master/tests/bluetooth/tester/btp_spec.txt

%package mpris-proxy
Summary: Bluetooth mpris proxy
Group: Networking/Other
Requires: %name = %EVR

%description mpris-proxy
Bluetooth mpris-player implements some features of MPRIS[1] specification.

1. https://specifications.freedesktop.org/mpris-spec/latest/

%package test-tools
Summary: BlueZ test tools
Group: Networking/Other
Requires: %name = %EVR

%description test-tools
This package contains test tools for using BlueZ.

%package -n zsh-completion-%name
Summary: Zsh completion for %name
Group: Shells
BuildArch: noarch
Requires: %name = %EVR

%description -n zsh-completion-%name
Zsh completion for %name.

%prep
%setup
%patch -p1

%build
%autoreconf
export CFLAGS="%optflags -DFIRMWARE_DIR=\\\"\"/lib/firmware\"\\\""
export MISC_CFLAGS="%optflags %(getconf LFS_CFLAGS)"
%configure \
	--enable-library \
	--enable-threads \
	--enable-external-ell \
	%{subst_enable midi} \
	%{subst_enable obex} \
	%{subst_enable btpclient} \
	--enable-cups \
	--enable-tools \
	--enable-hid2hci \
	--localstatedir=%_var \
	--with-systemdsystemunitdir=%_unitdir \
	%{subst_enable testing} \
	%{subst_enable deprecated} \
	%{subst_enable experimental}
%make_build

%install
%makeinstall_std
%{?_enable_deprecated:install -m755 attrib/gatttool %buildroot%_bindir/}
%{?_enable_btpclient:install -m755 tools/btpclient %buildroot%_bindir/}
%{?_enable_obex:install -m755 tools/obexctl %buildroot%_bindir/}
install -m755 tools/bneptest %buildroot%_bindir/
install -pD -m755 scripts/bluetooth.alt.init %buildroot%_initdir/bluetoothd
ln -s bluetooth.service %buildroot%_unitdir/bluetoothd.service
mkdir -p %buildroot%_libdir/bluetooth/plugins %buildroot%_localstatedir/bluetooth
%if_enabled testing
# install test tools
install -m 0755 tools/*-tester %buildroot/%_bindir/
install -m 0755 emulator/b1ee %buildroot/%_bindir/
install -m 0755 emulator/btvirt %buildroot/%_bindir/
install -m 0755 emulator/hfp %buildroot/%_bindir/
%endif

find %buildroot%_libdir -name \*.la -delete

%check
%make check

%post
SYSTEMCTL=systemctl
%post_service bluetoothd
if [ $1 = 1 ] && "$SYSTEMCTL" --version >/dev/null 2>&1; then
    "$SYSTEMCTL" -q --user --global enable obex.service >/dev/null 2>&1 || :
fi

%preun
SYSTEMCTL=systemctl
%preun_service bluetoothd
if [ $1 = 0 ] && "$SYSTEMCTL" --version >/dev/null 2>&1; then
	"$SYSTEMCTL" -q --user --global disable obex.service >/dev/null 2>&1 || :
fi

%files
%doc AUTHORS ChangeLog README
%attr(555,root,root) %dir %_sysconfdir/bluetooth
%config %_sysconfdir/bluetooth/main.conf
%config %_sysconfdir/bluetooth/input.conf
%config %_sysconfdir/bluetooth/network.conf
%_initdir/bluetoothd
%_unitdir/*.service
%{?_enable_obex:%_prefix/lib/systemd/user/obex.service}
%{?_enable_obex:%_prefix/lib/systemd/user/dbus-org.bluez.obex.service}
%{?_enable_obex:%_datadir/dbus-1/system.d/obex.conf}
%_udevrulesdir/*-hid2hci.rules
%_udevdir/hid2hci
%_bindir/bluemoon
%_bindir/bluetoothctl
%_bindir/btattach
%_bindir/btmon
%_bindir/hex2hcd
%_bindir/l2ping
%_bindir/l2test
%_bindir/rctest
%_bindir/bneptest
%_bindir/isotest
%{?_enable_obex:%_bindir/obexctl}
%if_enabled deprecated
%_bindir/ciptool
%_bindir/gatttool
%_bindir/hciattach
%_bindir/hciconfig
%_bindir/hcidump
%_bindir/hcitool
%_bindir/rfcomm
%_bindir/sdptool
%_man7dir/rfcomm.7*
%endif

%_libdir/bluetooth/
%_libexecdir/bluetooth/
%_datadir/dbus-1/system.d/bluetooth.conf
%_datadir/dbus-1/system-services/org.bluez.service
%{?_enable_obex:%_datadir/dbus-1/services/org.bluez.obex.service}
%_localstatedir/bluetooth
%_man1dir/*.1*
%_man8dir/*.8*

%files -n lib%name
%_libdir/*.so.*

%files -n lib%name-devel
%_includedir/bluetooth
%_libdir/*.so
%_pkgconfigdir/*.pc
%_man5dir/*.5*
%_man7dir/hci.7*
%_man7dir/iso.7*
%_man7dir/l2cap.7*
%_man7dir/mgmt.7*
%_man7dir/sco.7*

%files cups
%_prefix/lib/cups/backend/bluetooth

%if_enabled btpclient
%files btpclient
%_bindir/btpclient
%endif

%files mpris-proxy
%_bindir/mpris-proxy
%_user_unitdir/mpris-proxy.service

%files -n zsh-completion-%name
%_datadir/zsh/site-functions/_bluetoothctl

%if_enabled testing
%files test-tools
%_bindir/*-tester
%_bindir/b1ee
%_bindir/btvirt
%_bindir/hfp
%endif

%changelog
